/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch.tool;

import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.merge.MergeCallback;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.changes.patch.AppliedTextPatch;
import com.intellij.openapi.vcs.changes.patch.tool.ApplyPatchRequest;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyPatchMergeRequest
extends MergeRequest
implements ApplyPatchRequest {
    @Nullable
    private final Project myProject;
    @NotNull
    private final DocumentContent myResultContent;
    @NotNull
    private final AppliedTextPatch myAppliedPatch;
    @NotNull
    private final CharSequence myOriginalContent;
    @NotNull
    @NonNls
    private final String myLocalContent;
    @NlsContexts.DialogTitle
    @Nullable
    private final String myWindowTitle;
    private final @NlsContexts.Label @NotNull String myLocalTitle;
    private final @NlsContexts.Label @NotNull String myResultTitle;
    private final @NlsContexts.Label @NotNull String myPatchTitle;

    public ApplyPatchMergeRequest(@Nullable Project project, @NotNull DocumentContent resultContent, @NotNull AppliedTextPatch appliedPatch, @NotNull @NonNls String localContent, @NlsContexts.DialogTitle @Nullable String windowTitle, @NlsContexts.Label @NotNull String localTitle, @NlsContexts.Label @NotNull String resultTitle, @NlsContexts.Label @NotNull String patchTitle) {
        if (resultContent == null) {
            ApplyPatchMergeRequest.$$$reportNull$$$0(0);
        }
        if (appliedPatch == null) {
            ApplyPatchMergeRequest.$$$reportNull$$$0(1);
        }
        if (localContent == null) {
            ApplyPatchMergeRequest.$$$reportNull$$$0(2);
        }
        if (localTitle == null) {
            ApplyPatchMergeRequest.$$$reportNull$$$0(3);
        }
        if (resultTitle == null) {
            ApplyPatchMergeRequest.$$$reportNull$$$0(4);
        }
        if (patchTitle == null) {
            ApplyPatchMergeRequest.$$$reportNull$$$0(5);
        }
        this.myProject = project;
        this.myResultContent = resultContent;
        this.myAppliedPatch = appliedPatch;
        this.myOriginalContent = (CharSequence)ReadAction.compute(() -> this.myResultContent.getDocument().getImmutableCharSequence());
        this.myLocalContent = localContent;
        this.myWindowTitle = windowTitle;
        this.myLocalTitle = localTitle;
        this.myResultTitle = resultTitle;
        this.myPatchTitle = patchTitle;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @Override
    @NotNull
    public DocumentContent getResultContent() {
        DocumentContent documentContent = this.myResultContent;
        if (documentContent == null) {
            ApplyPatchMergeRequest.$$$reportNull$$$0(6);
        }
        return documentContent;
    }

    @Override
    @NotNull
    public String getLocalContent() {
        String string = this.myLocalContent;
        if (string == null) {
            ApplyPatchMergeRequest.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public AppliedTextPatch getPatch() {
        AppliedTextPatch appliedTextPatch = this.myAppliedPatch;
        if (appliedTextPatch == null) {
            ApplyPatchMergeRequest.$$$reportNull$$$0(8);
        }
        return appliedTextPatch;
    }

    @Override
    @Nullable
    public String getTitle() {
        return this.myWindowTitle;
    }

    @Override
    @NotNull
    public String getLocalTitle() {
        String string = this.myLocalTitle;
        if (string == null) {
            ApplyPatchMergeRequest.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @NotNull
    public String getResultTitle() {
        String string = this.myResultTitle;
        if (string == null) {
            ApplyPatchMergeRequest.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    @NotNull
    public String getPatchTitle() {
        String string = this.myPatchTitle;
        if (string == null) {
            ApplyPatchMergeRequest.$$$reportNull$$$0(11);
        }
        return string;
    }

    public void applyResult(@NotNull MergeResult result2) {
        String applyContent;
        if (result2 == null) {
            ApplyPatchMergeRequest.$$$reportNull$$$0(12);
        }
        switch (result2) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case CANCEL: {
                CharSequence charSequence;
                if (MergeUtil.shouldRestoreOriginalContentOnCancel((MergeRequest)this)) {
                    charSequence = this.myOriginalContent;
                    break;
                }
                charSequence = null;
                break;
            }
            case LEFT: {
                CharSequence charSequence = this.myLocalContent;
                break;
            }
            case RIGHT: {
                throw new UnsupportedOperationException();
            }
            case RESOLVED: {
                CharSequence charSequence = applyContent = null;
            }
        }
        if (applyContent != null) {
            WriteCommandAction.writeCommandAction((Project)this.myProject).run(() -> this.myResultContent.getDocument().setText(applyContent));
        }
        MergeCallback.getCallback((MergeRequest)this).applyResult(result2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultContent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appliedPatch";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localContent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localTitle";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultTitle";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchTitle";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchMergeRequest";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchMergeRequest";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultContent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalContent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatch";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalTitle";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultTitle";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatchTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "applyResult";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

