# Author: Enric Tejedor CERN  02/2019

################################################################################
# Copyright (C) 1995-2019, Rene Brun and Fons Rademakers.                      #
# All rights reserved.                                                         #
#                                                                              #
# For the licensing terms see $ROOTSYS/LICENSE.                                #
# For the list of contributors see $ROOTSYS/README/CREDITS.                    #
################################################################################

from . import pythonization


@pythonization('TString')
def pythonize_tstring(klass):
    # Parameters:
    # klass: class to be pythonized

    # Add string representation
    klass.__str__  = klass.Data
    klass.__repr__ = lambda self: "'{}'".format(self)

    # Add comparison operators
    klass.__eq__ = lambda self, o: str(self) == o
    klass.__ne__ = lambda self, o: str(self) != o
    klass.__lt__ = lambda self, o: str(self) <  o
    klass.__le__ = lambda self, o: str(self) <= o
    klass.__gt__ = lambda self, o: str(self) >  o
    klass.__ge__ = lambda self, o: str(self) >= o
