/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.theme;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;
import net.infonode.gui.DimensionProvider;
import net.infonode.gui.InsetsUtil;
import net.infonode.gui.componentpainter.ComponentPainter;
import net.infonode.gui.hover.HoverEvent;
import net.infonode.gui.hover.HoverListener;
import net.infonode.properties.propertymap.PropertyMapManager;
import net.infonode.tabbedpanel.Tab;
import net.infonode.tabbedpanel.TabbedPanel;
import net.infonode.tabbedpanel.TabbedPanelContentPanel;
import net.infonode.tabbedpanel.TabbedPanelProperties;
import net.infonode.tabbedpanel.TabbedUtils;
import net.infonode.tabbedpanel.theme.TabbedPanelTitledTabTheme;
import net.infonode.tabbedpanel.theme.internal.laftheme.PaneUI;
import net.infonode.tabbedpanel.theme.internal.laftheme.PaneUIListener;
import net.infonode.tabbedpanel.titledtab.TitledTab;
import net.infonode.tabbedpanel.titledtab.TitledTabBorderSizePolicy;
import net.infonode.tabbedpanel.titledtab.TitledTabProperties;
import net.infonode.tabbedpanel.titledtab.TitledTabSizePolicy;
import net.infonode.util.Direction;

public class LookAndFeelTheme
extends TabbedPanelTitledTabTheme {
    private static TabbedPanelProperties tpProps = new TabbedPanelProperties();
    private static TitledTabProperties tabProps = new TitledTabProperties();
    private TabbedPanelProperties themeTpProps = new TabbedPanelProperties();
    private TitledTabProperties themeTabProps = new TitledTabProperties();
    private static int themeCounter = 0;
    private static PaneUI ui;
    private boolean disposed = false;

    public LookAndFeelTheme() {
        if (themeCounter == 0) {
            ui = new PaneUI(new PaneUIListener(){

                @Override
                public void updating() {
                }

                @Override
                public void updated() {
                    LookAndFeelTheme.this.initTheme();
                }
            });
            ui.init();
        }
        ++themeCounter;
        this.themeTpProps.addSuperObject(tpProps);
        this.themeTabProps.addSuperObject(tabProps);
    }

    @Override
    public String getName() {
        return "Look and Feel Theme";
    }

    @Override
    public TabbedPanelProperties getTabbedPanelProperties() {
        return this.themeTpProps;
    }

    @Override
    public TitledTabProperties getTitledTabProperties() {
        return this.themeTabProps;
    }

    public void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            if (--themeCounter == 0) {
                ui.dispose();
                PropertyMapManager.runBatch(new Runnable(){

                    @Override
                    public void run() {
                        tpProps.getMap().clear(true);
                        tabProps.getMap().clear(true);
                    }
                });
            }
        }
    }

    private void initTheme() {
        PropertyMapManager.runBatch(new Runnable(){

            @Override
            public void run() {
                tpProps.getMap().clear(true);
                tabProps.getMap().clear(true);
                tpProps.setShadowEnabled(false).setTabSpacing(ui.getTabSpacing()).setTabScrollingOffset(ui.getScrollOffset()).setEnsureSelectedTabVisible(true);
                tpProps.getTabAreaComponentsProperties().getComponentProperties().setBorder(null).setInsets(InsetsUtil.EMPTY_INSETS);
                tpProps.getTabAreaProperties().getComponentProperties().setInsets(InsetsUtil.EMPTY_INSETS).setBorder(new Border(){

                    @Override
                    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                    }

                    @Override
                    public Insets getBorderInsets(Component c) {
                        TabbedPanel tp = TabbedUtils.getParentTabbedPanel(c);
                        return tp.isTabAreaVisible() ? ui.getTabAreaInsets(tp.getProperties().getTabAreaOrientation()) : InsetsUtil.EMPTY_INSETS;
                    }

                    @Override
                    public boolean isBorderOpaque() {
                        return false;
                    }
                });
                tpProps.getTabAreaComponentsProperties().getShapedPanelProperties().setOpaque(ui.isTabAreaComponentsOpaque());
                tpProps.getTabAreaProperties().getShapedPanelProperties().setOpaque(ui.isTabAreaOpaque()).setComponentPainter(new ComponentPainter(){

                    @Override
                    public void paint(Component component, Graphics g, int x, int y, int width, int height) {
                    }

                    @Override
                    public void paint(Component component, Graphics g, int x, int y, int width, int height, Direction direction, boolean horizontalFlip, boolean verticalFlip) {
                        ui.paintTabArea(TabbedUtils.getParentTabbedPanel(component), g, x, y, width, height);
                    }

                    @Override
                    public boolean isOpaque(Component component) {
                        return false;
                    }

                    @Override
                    public Color getColor(Component component) {
                        return null;
                    }
                });
                tpProps.getContentPanelProperties().getShapedPanelProperties().setOpaque(ui.isContentOpaque()).setComponentPainter(new ComponentPainter(){

                    @Override
                    public void paint(Component component, Graphics g, int x, int y, int width, int height) {
                    }

                    @Override
                    public void paint(Component component, Graphics g, int x, int y, int width, int height, Direction direction, boolean horizontalFlip, boolean verticalFlip) {
                        TabbedPanelContentPanel p = TabbedUtils.getParentTabbedPanelContentPanel(component);
                        ui.paintContentArea(p, g, x, y, width, height);
                    }

                    @Override
                    public boolean isOpaque(Component component) {
                        return false;
                    }

                    @Override
                    public Color getColor(Component component) {
                        return null;
                    }
                });
                tpProps.getContentPanelProperties().getComponentProperties().setInsets(InsetsUtil.EMPTY_INSETS).setBorder(new Border(){

                    @Override
                    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                    }

                    @Override
                    public Insets getBorderInsets(Component c) {
                        TabbedPanel tp = TabbedUtils.getParentTabbedPanelContentPanel(c).getTabbedPanel();
                        return ui.getContentInsets(tp.getProperties().getTabAreaOrientation(), tp.isTabAreaVisible());
                    }

                    @Override
                    public boolean isBorderOpaque() {
                        return false;
                    }
                });
                tabProps.setSizePolicy(TitledTabSizePolicy.INDIVIDUAL_SIZE).setBorderSizePolicy(TitledTabBorderSizePolicy.EQUAL_SIZE).setHighlightedRaised(ui.getSelectedRaised(Direction.UP)).setFocusMarkerEnabled(false);
                tabProps.getNormalProperties().setIconTextGap(ui.getTextIconGap()).setTextTitleComponentGap(ui.getTextIconGap());
                tabProps.getNormalProperties().getComponentProperties().setInsets(InsetsUtil.EMPTY_INSETS).setBorder(LookAndFeelTheme.this.createTabInsetsBorder(false)).setFont(ui.getFont());
                tabProps.getHighlightedProperties().getComponentProperties().setBorder(LookAndFeelTheme.this.createTabInsetsBorder(true));
                tabProps.getDisabledProperties().getComponentProperties().setBorder(LookAndFeelTheme.this.createTabInsetsBorder(false));
                tabProps.getNormalProperties().getShapedPanelProperties().setOpaque(false).setComponentPainter(null);
                tabProps.setMinimumSizeProvider(new DimensionProvider(){

                    @Override
                    public Dimension getDimension(Component c) {
                        return ui.getTabExternalMinSize(TabbedUtils.getParentTab(c).getTabbedPanel().getProperties().getTabAreaOrientation());
                    }
                });
                tabProps.setHoverListener(new HoverListener(){

                    @Override
                    public void mouseEntered(HoverEvent event) {
                        ui.setHoveredTab((Tab)event.getSource());
                    }

                    @Override
                    public void mouseExited(HoverEvent event) {
                        ui.setHoveredTab(null);
                    }
                });
            }
        });
    }

    private Border createTabInsetsBorder(final boolean selected) {
        return new Border(){

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            }

            @Override
            public Insets getBorderInsets(Component c) {
                TitledTab tab = (TitledTab)TabbedUtils.getParentTab(c);
                if (tab.getTabbedPanel() == null) {
                    return new Insets(0, 0, 0, 0);
                }
                Direction areaOrientation = tab.getTabbedPanel().getProperties().getTabAreaOrientation();
                Direction tabDirection = selected ? tab.getProperties().getHighlightedProperties().getDirection() : tab.getProperties().getNormalProperties().getDirection();
                return selected ? ui.getSelectedTabInsets(areaOrientation, tabDirection) : ui.getNormalTabInsets(areaOrientation, tabDirection);
            }

            @Override
            public boolean isBorderOpaque() {
                return false;
            }
        };
    }

    public Color getBorderColor(Direction d) {
        return ui.getContentTabAreaBorderColor(d);
    }
}

