/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.AttributeComponent;
import com.lightdev.app.shtm.ColorPanel;
import com.lightdev.app.shtm.CombinedAttribute;
import com.lightdev.app.shtm.SizeSelectorPanel;
import com.lightdev.app.shtm.Util;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.CSS;

class BorderPanel
extends JPanel
implements AttributeComponent {
    private final Vector components = new Vector();
    private CombinedAttribute bWidth;
    private CombinedAttribute bColor;
    private String oColor;
    private String oWidth;
    private int setValueCalls = 0;

    public BorderPanel() {
        GridBagLayout g = new GridBagLayout();
        this.setLayout(g);
        GridBagConstraints c = new GridBagConstraints();
        this.addSettings(g, c, Util.getResourceString("topLabel"), 0, 0, 0);
        this.addSettings(g, c, Util.getResourceString("rightLabel"), 1, 1, 1);
        this.addSettings(g, c, Util.getResourceString("bottomLabel"), 2, 1, 0);
        this.addSettings(g, c, Util.getResourceString("leftLabel"), 3, 0, 1);
    }

    private void addSettings(GridBagLayout g, GridBagConstraints c, String title, int side, int x, int y) {
        BorderSettings bs = new BorderSettings(title, side);
        Util.addGridBagComponent(this, bs, g, c, x, y, 17);
        this.components.addElement(bs);
    }

    @Override
    public boolean setValue(AttributeSet a) {
        boolean success = true;
        Enumeration e = this.components.elements();
        this.bWidth = new CombinedAttribute(CSS.Attribute.BORDER_WIDTH, a, true);
        this.bColor = new CombinedAttribute(CSS.Attribute.BORDER_COLOR, a, true);
        if (++this.setValueCalls < 2) {
            this.oColor = this.bColor.getAttribute();
            this.oWidth = this.bWidth.getAttribute();
        }
        while (e.hasMoreElements()) {
            ((BorderSettings)e.nextElement()).setValue(this.bWidth, this.bColor);
        }
        return true;
    }

    @Override
    public AttributeSet getValue() {
        SimpleAttributeSet set = new SimpleAttributeSet();
        for (int i = 0; i < this.components.size(); ++i) {
            BorderSettings bs = (BorderSettings)this.components.elementAt(i);
            this.bColor.setAttribute(i, bs.getBorderColor());
            this.bWidth.setAttribute(i, bs.getBorderWidth());
        }
        String newValue = this.bWidth.getAttribute(0);
        Util.styleSheet().addCSSAttribute(set, CSS.Attribute.BORDER_TOP_WIDTH, newValue);
        Util.styleSheet().addCSSAttribute(set, CSS.Attribute.BORDER_RIGHT_WIDTH, newValue);
        Util.styleSheet().addCSSAttribute(set, CSS.Attribute.BORDER_BOTTOM_WIDTH, newValue);
        Util.styleSheet().addCSSAttribute(set, CSS.Attribute.BORDER_LEFT_WIDTH, newValue);
        return set;
    }

    @Override
    public AttributeSet getValue(boolean includeUnchanged) {
        if (includeUnchanged) {
            SimpleAttributeSet set = new SimpleAttributeSet();
            for (int i = 0; i < this.components.size(); ++i) {
                BorderSettings bs = (BorderSettings)this.components.elementAt(i);
                this.bColor.setAttribute(i, bs.getBorderColor());
                this.bWidth.setAttribute(i, bs.getBorderWidth());
            }
            String newValue = this.bWidth.getAttribute(0);
            Util.styleSheet().addCSSAttribute(set, CSS.Attribute.BORDER_TOP_WIDTH, newValue);
            Util.styleSheet().addCSSAttribute(set, CSS.Attribute.BORDER_RIGHT_WIDTH, newValue);
            Util.styleSheet().addCSSAttribute(set, CSS.Attribute.BORDER_BOTTOM_WIDTH, newValue);
            Util.styleSheet().addCSSAttribute(set, CSS.Attribute.BORDER_LEFT_WIDTH, newValue);
            return set;
        }
        return this.getValue();
    }

    private static class BorderSettings
    extends JPanel {
        private final int side;
        private final SizeSelectorPanel bWidth;
        private final ColorPanel bColor;

        public BorderSettings(String title, int side) {
            this.side = side;
            GridBagLayout g = new GridBagLayout();
            this.setLayout(g);
            GridBagConstraints c = new GridBagConstraints();
            this.setBorder(new TitledBorder(new EtchedBorder(1), title));
            Util.addGridBagComponent(this, new JLabel(Util.getResourceString("borderWidthLabel")), g, c, 0, 0, 13);
            this.bWidth = new SizeSelectorPanel(CSS.Attribute.BORDER_WIDTH, null, false, 1);
            Util.addGridBagComponent(this, this.bWidth, g, c, 1, 0, 17);
            Util.addGridBagComponent(this, new JLabel(Util.getResourceString("borderColorLabel")), g, c, 0, 1, 13);
            this.bColor = new ColorPanel(null);
            Util.addGridBagComponent(this, this.bColor, g, c, 1, 1, 17);
        }

        public String getBorderColor() {
            return this.bColor.getAttr();
        }

        public String getBorderWidth() {
            return this.bWidth.getAttr();
        }

        public void setValue(CombinedAttribute borderWidths, CombinedAttribute borderColors) {
            String attr = borderColors.getAttribute(this.side);
            if (attr != null) {
                this.bColor.setValue(attr);
            }
            if ((attr = borderWidths.getAttribute(this.side)) != null) {
                this.bWidth.setValue(attr);
            }
        }
    }
}

