/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import org.freeplane.core.ui.components.UITools;

public class SafeRunner {
    private static final int WAITING_TIME_AFTER_FAILURE_MILLIS = 50;

    public static void run(int remainingAttempts, Runnable runnable) {
        while (true) {
            try {
                runnable.run();
                return;
            }
            catch (RuntimeException e) {
                if (--remainingAttempts <= 0) {
                    String errorMessage = e.getMessage();
                    if (errorMessage != null) {
                        UITools.errorMessage(errorMessage);
                    }
                    return;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }
}

