/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.knopflerfish.framework.BundleCapabilityImpl;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.BundleReferenceImpl;
import org.knopflerfish.framework.BundleRequirementImpl;
import org.knopflerfish.framework.BundleWiringImpl;
import org.knopflerfish.framework.DTOId;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.dto.BundleRevisionDTO;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.dto.CapabilityRefDTO;
import org.osgi.resource.dto.RequirementRefDTO;

public class BundleRevisionImpl
extends BundleReferenceImpl
implements BundleRevision {
    static final int NS_BUNDLE = 1;
    static final int NS_HOST = 2;
    static final int NS_IDENTITY = 4;
    static final int NS_NATIVE = 8;
    static final int NS_PACKAGE = 16;
    static final int NS_OTHER = 32;
    final BundleGeneration gen;
    private BundleWiringImpl bundleWiring = null;

    BundleRevisionImpl(BundleGeneration gen) {
        super(gen.bundle);
        this.gen = gen;
    }

    @Override
    public String getSymbolicName() {
        return this.gen.symbolicName;
    }

    @Override
    public Version getVersion() {
        return this.gen.version;
    }

    @Override
    public List<BundleCapability> getDeclaredCapabilities(String namespace) {
        DTOId bc;
        ArrayList<BundleCapability> res = new ArrayList<BundleCapability>();
        int ns = BundleRevisionImpl.whichNameSpaces(namespace);
        if ((ns & 4) != 0 && (bc = this.gen.identity) != null) {
            res.add((BundleCapability)((Object)bc));
        }
        if ((ns & 1) != 0 && (bc = this.gen.bundleCapability) != null) {
            res.add((BundleCapability)((Object)bc));
        }
        if ((ns & 2) != 0 && (bc = this.gen.hostCapability) != null) {
            res.add((BundleCapability)((Object)bc));
        }
        if ((ns & 0x10) != 0) {
            res.addAll(this.gen.bpkgs.getDeclaredPackageCapabilities());
        }
        if ((ns & 0x28) != 0) {
            Map<String, List<BundleCapabilityImpl>> caps = this.gen.getDeclaredCapabilities();
            if (null != namespace) {
                List<BundleCapabilityImpl> lcap = caps.get(namespace);
                if (lcap != null) {
                    res.addAll(lcap);
                }
            } else {
                for (List<BundleCapabilityImpl> lcap : caps.values()) {
                    res.addAll(lcap);
                }
            }
        }
        return res;
    }

    @Override
    public List<BundleRequirement> getDeclaredRequirements(String namespace) {
        ArrayList<BundleRequirement> res = new ArrayList<BundleRequirement>();
        int ns = BundleRevisionImpl.whichNameSpaces(namespace);
        if ((ns & 1) != 0) {
            res.addAll(this.gen.bpkgs.getDeclaredBundleRequirements());
        }
        if ((ns & 2) != 0 && this.gen.isFragment()) {
            res.add(this.gen.fragment);
        }
        if ((ns & 0x10) != 0) {
            res.addAll(this.gen.bpkgs.getDeclaredPackageRequirements());
        }
        if ((ns & 0x2C) != 0) {
            if ((ns & 8) != 0 && this.gen.nativeRequirement != null) {
                res.add(this.gen.nativeRequirement);
            }
            Map<String, List<BundleRequirementImpl>> reqs = this.gen.getDeclaredRequirements();
            if (null != namespace) {
                List<BundleRequirementImpl> lbr = reqs.get(namespace);
                if (lbr != null) {
                    res.addAll(lbr);
                }
            } else {
                for (List<BundleRequirementImpl> lbr : reqs.values()) {
                    res.addAll(lbr);
                }
            }
        }
        return res;
    }

    @Override
    public List<Capability> getCapabilities(String namespace) {
        return this.getDeclaredCapabilities(namespace);
    }

    @Override
    public List<Requirement> getRequirements(String namespace) {
        return this.getDeclaredRequirements(namespace);
    }

    @Override
    public int getTypes() {
        return this.gen.isFragment() ? 1 : 0;
    }

    @Override
    public BundleWiring getWiring() {
        return this.bundleWiring;
    }

    public String toString() {
        return "BundleRevision[" + this.getSymbolicName() + ":" + this.getVersion() + "]";
    }

    BundleGeneration getBundleGeneration() {
        return this.gen;
    }

    BundleWiringImpl getWiringImpl() {
        return this.bundleWiring;
    }

    void setWired() {
        this.bundleWiring = new BundleWiringImpl(this);
    }

    void clearWiring() {
        this.bundleWiring = null;
    }

    BundleRevisionDTO getDTO() {
        BundleRevisionDTO res = new BundleRevisionDTO();
        res.symbolicName = this.gen.symbolicName;
        res.type = this.getTypes();
        res.version = this.gen.version.toString();
        res.bundle = this.gen.bundle.id;
        res.id = this.dtoId;
        res.capabilities = new ArrayList();
        for (BundleCapability bc : this.getDeclaredCapabilities(null)) {
            res.capabilities.add(BundleCapabilityImpl.getDTO(bc, this));
        }
        res.requirements = new ArrayList();
        for (BundleRequirement br : this.getDeclaredRequirements(null)) {
            res.requirements.add(BundleRequirementImpl.getDTO(br, this));
        }
        return res;
    }

    List<CapabilityRefDTO> getCapabilityRefDTOs() {
        ArrayList<CapabilityRefDTO> res = new ArrayList<CapabilityRefDTO>();
        for (BundleCapability bc : this.getDeclaredCapabilities(null)) {
            res.add(BundleCapabilityImpl.getRefDTO(bc, this));
        }
        return res;
    }

    List<RequirementRefDTO> getRequirementRefDTOs() {
        ArrayList<RequirementRefDTO> res = new ArrayList<RequirementRefDTO>();
        for (BundleRequirement br : this.getDeclaredRequirements(null)) {
            res.add(BundleRequirementImpl.getRefDTO(br, this));
        }
        return res;
    }

    static int whichNameSpaces(String namespace) {
        int ns = namespace == null ? 55 : ("osgi.wiring.bundle".equals(namespace) ? 1 : ("osgi.wiring.host".equals(namespace) ? 2 : ("osgi.identity".equals(namespace) ? 4 : ("osgi.native".equals(namespace) ? 8 : ("osgi.wiring.package".equals(namespace) ? 16 : 32)))));
        return ns;
    }
}

