/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityUtilities;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableObject;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.debug.Debugger;
import org.mozilla.javascript.tools.debugger.GuiCallback;
import org.mozilla.javascript.tools.debugger.ScopeProvider;

public class Dim {
    public static final int STEP_OVER = 0;
    public static final int STEP_INTO = 1;
    public static final int STEP_OUT = 2;
    public static final int GO = 3;
    public static final int BREAK = 4;
    public static final int EXIT = 5;
    private static final int IPROXY_DEBUG = 0;
    private static final int IPROXY_LISTEN = 1;
    private static final int IPROXY_COMPILE_SCRIPT = 2;
    private static final int IPROXY_EVAL_SCRIPT = 3;
    private static final int IPROXY_STRING_IS_COMPILABLE = 4;
    private static final int IPROXY_OBJECT_TO_STRING = 5;
    private static final int IPROXY_OBJECT_PROPERTY = 6;
    private static final int IPROXY_OBJECT_IDS = 7;
    private GuiCallback callback;
    private boolean breakFlag;
    private ScopeProvider scopeProvider;
    private int frameIndex = -1;
    private volatile ContextData interruptedContextData;
    private ContextFactory contextFactory;
    private Object monitor = new Object();
    private Object eventThreadMonitor = new Object();
    private volatile int returnValue = -1;
    private boolean insideInterruptLoop;
    private String evalRequest;
    private StackFrame evalFrame;
    private String evalResult;
    private boolean breakOnExceptions;
    private boolean breakOnEnter;
    private boolean breakOnReturn;
    private final Hashtable urlToSourceInfo = new Hashtable();
    private final Hashtable functionNames = new Hashtable();
    private final Hashtable functionToSource = new Hashtable();
    private DimIProxy listener;

    public void setGuiCallback(GuiCallback guiCallback) {
        this.callback = guiCallback;
    }

    public void setBreak() {
        this.breakFlag = true;
    }

    public void setScopeProvider(ScopeProvider scopeProvider) {
        this.scopeProvider = scopeProvider;
    }

    public void contextSwitch(int n) {
        this.frameIndex = n;
    }

    public void setBreakOnExceptions(boolean bl) {
        this.breakOnExceptions = bl;
    }

    public void setBreakOnEnter(boolean bl) {
        this.breakOnEnter = bl;
    }

    public void setBreakOnReturn(boolean bl) {
        this.breakOnReturn = bl;
    }

    public void attachTo(ContextFactory contextFactory) {
        this.detach();
        this.contextFactory = contextFactory;
        this.listener = new DimIProxy(this, 1);
        contextFactory.addListener(this.listener);
    }

    public void detach() {
        if (this.listener != null) {
            this.contextFactory.removeListener(this.listener);
            this.contextFactory = null;
            this.listener = null;
        }
    }

    public void dispose() {
        this.detach();
    }

    private FunctionSource getFunctionSource(DebuggableScript debuggableScript) {
        String string;
        String string2;
        SourceInfo sourceInfo;
        FunctionSource functionSource = this.functionSource(debuggableScript);
        if (functionSource == null && (sourceInfo = this.sourceInfo(string2 = this.getNormalizedUrl(debuggableScript))) == null && !debuggableScript.isGeneratedScript() && (string = this.loadSource(string2)) != null) {
            DebuggableScript debuggableScript2;
            DebuggableScript debuggableScript3 = debuggableScript;
            while ((debuggableScript2 = debuggableScript3.getParent()) != null) {
                debuggableScript3 = debuggableScript2;
            }
            this.registerTopScript(debuggableScript3, string);
            functionSource = this.functionSource(debuggableScript);
        }
        return functionSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadSource(String string) {
        String string2 = null;
        int n = string.indexOf(35);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        try {
            InputStream inputStream;
            block10: {
                if (string.indexOf(58) < 0) {
                    block11: {
                        try {
                            String string3;
                            File file;
                            Object object;
                            if (string.startsWith("~/") && (object = SecurityUtilities.getSystemProperty("user.home")) != null && (file = new File(new File((String)object), string3 = string.substring(2))).exists()) {
                                inputStream = new FileInputStream(file);
                                break block10;
                            }
                            object = new File(string);
                            if (!((File)object).exists()) break block11;
                            inputStream = new FileInputStream((File)object);
                            break block10;
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                    }
                    string = string.startsWith("//") ? "http:" + string : (string.startsWith("/") ? "http://127.0.0.1" + string : "http://" + string);
                }
                inputStream = new URL(string).openStream();
            }
            try {
                string2 = Kit.readReader(new InputStreamReader(inputStream));
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            System.err.println("Failed to load source from " + string + ": " + iOException);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerTopScript(DebuggableScript debuggableScript, String string) {
        if (!debuggableScript.isTopLevel()) {
            throw new IllegalArgumentException();
        }
        String string2 = this.getNormalizedUrl(debuggableScript);
        DebuggableScript[] debuggableScriptArray = Dim.getAllFunctions(debuggableScript);
        SourceInfo sourceInfo = new SourceInfo(string, debuggableScriptArray, string2);
        Hashtable hashtable = this.urlToSourceInfo;
        synchronized (hashtable) {
            SourceInfo sourceInfo2 = (SourceInfo)this.urlToSourceInfo.get(string2);
            if (sourceInfo2 != null) {
                sourceInfo.copyBreakpointsFrom(sourceInfo2);
            }
            this.urlToSourceInfo.put(string2, sourceInfo);
            for (int i = 0; i != sourceInfo.functionSourcesTop(); ++i) {
                FunctionSource functionSource = sourceInfo.functionSource(i);
                String string3 = functionSource.name();
                if (string3.length() == 0) continue;
                this.functionNames.put(string3, functionSource);
            }
        }
        hashtable = this.functionToSource;
        synchronized (hashtable) {
            for (int i = 0; i != debuggableScriptArray.length; ++i) {
                FunctionSource functionSource = sourceInfo.functionSource(i);
                this.functionToSource.put(debuggableScriptArray[i], functionSource);
            }
        }
        this.callback.updateSourceText(sourceInfo);
    }

    private FunctionSource functionSource(DebuggableScript debuggableScript) {
        return (FunctionSource)this.functionToSource.get(debuggableScript);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] functionNames() {
        String[] stringArray;
        Hashtable hashtable = this.urlToSourceInfo;
        synchronized (hashtable) {
            Enumeration enumeration = this.functionNames.keys();
            stringArray = new String[this.functionNames.size()];
            int n = 0;
            while (enumeration.hasMoreElements()) {
                stringArray[n++] = (String)enumeration.nextElement();
            }
        }
        return stringArray;
    }

    public FunctionSource functionSourceByName(String string) {
        return (FunctionSource)this.functionNames.get(string);
    }

    public SourceInfo sourceInfo(String string) {
        return (SourceInfo)this.urlToSourceInfo.get(string);
    }

    private String getNormalizedUrl(DebuggableScript debuggableScript) {
        String string = debuggableScript.getSourceName();
        if (string == null) {
            string = "<stdin>";
        } else {
            int n;
            int n2 = 35;
            StringBuffer stringBuffer = null;
            int n3 = string.length();
            int n4 = 0;
            while ((n = string.indexOf(n2, n4)) >= 0) {
                char c;
                int n5;
                String string2 = null;
                for (n5 = n + 1; n5 != n3 && '0' <= (c = string.charAt(n5)) && c <= '9'; ++n5) {
                }
                if (n5 != n + 1 && "(eval)".regionMatches(0, string, n5, 6)) {
                    n4 = n5 + 6;
                    string2 = "(eval)";
                }
                if (string2 == null) break;
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(string.substring(0, n));
                }
                stringBuffer.append(string2);
            }
            if (stringBuffer != null) {
                if (n4 != n3) {
                    stringBuffer.append(string.substring(n4));
                }
                string = stringBuffer.toString();
            }
        }
        return string;
    }

    private static DebuggableScript[] getAllFunctions(DebuggableScript debuggableScript) {
        ObjArray objArray = new ObjArray();
        Dim.collectFunctions_r(debuggableScript, objArray);
        Object[] objectArray = new DebuggableScript[objArray.size()];
        objArray.toArray(objectArray);
        return objectArray;
    }

    private static void collectFunctions_r(DebuggableScript debuggableScript, ObjArray objArray) {
        objArray.add(debuggableScript);
        for (int i = 0; i != debuggableScript.getFunctionCount(); ++i) {
            Dim.collectFunctions_r(debuggableScript.getFunction(i), objArray);
        }
    }

    public void clearAllBreakpoints() {
        Enumeration enumeration = this.urlToSourceInfo.elements();
        while (enumeration.hasMoreElements()) {
            SourceInfo sourceInfo = (SourceInfo)enumeration.nextElement();
            sourceInfo.removeAllBreakpoints();
        }
    }

    private void handleBreakpointHit(StackFrame stackFrame, Context context) {
        this.breakFlag = false;
        this.interrupted(context, stackFrame, null);
    }

    private void handleExceptionThrown(Context context, Throwable throwable, StackFrame stackFrame) {
        ContextData contextData;
        if (this.breakOnExceptions && (contextData = stackFrame.contextData()).lastProcessedException != throwable) {
            this.interrupted(context, stackFrame, throwable);
            contextData.lastProcessedException = throwable;
        }
    }

    public ContextData currentContextData() {
        return this.interruptedContextData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReturnValue(int n) {
        Object object = this.monitor;
        synchronized (object) {
            this.returnValue = n;
            this.monitor.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void go() {
        Object object = this.monitor;
        synchronized (object) {
            this.returnValue = 3;
            this.monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String eval(String string) {
        String string2 = "undefined";
        if (string == null) {
            return string2;
        }
        ContextData contextData = this.currentContextData();
        if (contextData == null || this.frameIndex >= contextData.frameCount()) {
            return string2;
        }
        StackFrame stackFrame = contextData.getFrame(this.frameIndex);
        if (contextData.eventThreadFlag) {
            Context context = Context.getCurrentContext();
            string2 = Dim.do_eval(context, stackFrame, string);
        } else {
            Object object = this.monitor;
            synchronized (object) {
                if (this.insideInterruptLoop) {
                    this.evalRequest = string;
                    this.evalFrame = stackFrame;
                    this.monitor.notify();
                    do {
                        try {
                            this.monitor.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                            break;
                        }
                    } while (this.evalRequest != null);
                    string2 = this.evalResult;
                }
            }
        }
        return string2;
    }

    public void compileScript(String string, String string2) {
        DimIProxy dimIProxy = new DimIProxy(this, 2);
        dimIProxy.url = string;
        dimIProxy.text = string2;
        dimIProxy.withContext();
    }

    public void evalScript(String string, String string2) {
        DimIProxy dimIProxy = new DimIProxy(this, 3);
        dimIProxy.url = string;
        dimIProxy.text = string2;
        dimIProxy.withContext();
    }

    public String objectToString(Object object) {
        DimIProxy dimIProxy = new DimIProxy(this, 5);
        dimIProxy.object = object;
        dimIProxy.withContext();
        return dimIProxy.stringResult;
    }

    public boolean stringIsCompilableUnit(String string) {
        DimIProxy dimIProxy = new DimIProxy(this, 4);
        dimIProxy.text = string;
        dimIProxy.withContext();
        return dimIProxy.booleanResult;
    }

    public Object getObjectProperty(Object object, Object object2) {
        DimIProxy dimIProxy = new DimIProxy(this, 6);
        dimIProxy.object = object;
        dimIProxy.id = object2;
        dimIProxy.withContext();
        return dimIProxy.objectResult;
    }

    public Object[] getObjectIds(Object object) {
        DimIProxy dimIProxy = new DimIProxy(this, 7);
        dimIProxy.object = object;
        dimIProxy.withContext();
        return dimIProxy.objectArrayResult;
    }

    private Object getObjectPropertyImpl(Context context, Object object, Object object2) {
        Object object3;
        Scriptable scriptable = (Scriptable)object;
        if (object2 instanceof String) {
            String string = (String)object2;
            if (string.equals("this")) {
                object3 = scriptable;
            } else if (string.equals("__proto__")) {
                object3 = scriptable.getPrototype();
            } else if (string.equals("__parent__")) {
                object3 = scriptable.getParentScope();
            } else {
                object3 = ScriptableObject.getProperty(scriptable, string);
                if (object3 == ScriptableObject.NOT_FOUND) {
                    object3 = Undefined.instance;
                }
            }
        } else {
            int n = (Integer)object2;
            object3 = ScriptableObject.getProperty(scriptable, n);
            if (object3 == ScriptableObject.NOT_FOUND) {
                object3 = Undefined.instance;
            }
        }
        return object3;
    }

    private Object[] getObjectIdsImpl(Context context, Object object) {
        if (!(object instanceof Scriptable) || object == Undefined.instance) {
            return Context.emptyArgs;
        }
        Scriptable scriptable = (Scriptable)object;
        Object[] objectArray = scriptable instanceof DebuggableObject ? ((DebuggableObject)((Object)scriptable)).getAllIds() : scriptable.getIds();
        Scriptable scriptable2 = scriptable.getPrototype();
        Scriptable scriptable3 = scriptable.getParentScope();
        int n = 0;
        if (scriptable2 != null) {
            ++n;
        }
        if (scriptable3 != null) {
            ++n;
        }
        if (n != 0) {
            Object[] objectArray2 = new Object[n + objectArray.length];
            System.arraycopy(objectArray, 0, objectArray2, n, objectArray.length);
            objectArray = objectArray2;
            n = 0;
            if (scriptable2 != null) {
                objectArray[n++] = "__proto__";
            }
            if (scriptable3 != null) {
                objectArray[n++] = "__parent__";
            }
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void interrupted(Context var1_1, StackFrame var2_2, Throwable var3_3) {
        block43: {
            var4_4 = var2_2.contextData();
            var5_5 = this.callback.isGuiEventThread();
            ContextData.access$402(var4_4, var5_5);
            var6_6 = false;
            var7_7 = this.eventThreadMonitor;
            synchronized (var7_7) {
                if (var5_5) {
                    if (this.interruptedContextData != null) {
                        var6_6 = true;
                        break block43;
                    }
                } else {
                    while (this.interruptedContextData != null) {
                        try {
                            this.eventThreadMonitor.wait();
                        }
                        catch (InterruptedException var8_10) {
                            return;
                        }
                    }
                }
                this.interruptedContextData = var4_4;
            }
        }
        if (var6_6) {
            return;
        }
        if (this.interruptedContextData == null) {
            Kit.codeBug();
        }
        try {
            var7_8 = var4_4.frameCount();
            this.frameIndex = var7_8 - 1;
            var8_11 = Thread.currentThread().toString();
            var9_13 = var3_3 == null ? null : var3_3.toString();
            var10_14 = -1;
            if (!var5_5) {
                var11_15 = this.monitor;
                synchronized (var11_15) {
                    block44: {
                        if (this.insideInterruptLoop) {
                            Kit.codeBug();
                        }
                        this.insideInterruptLoop = true;
                        this.evalRequest = null;
                        this.returnValue = -1;
                        this.callback.enterInterrupt(var2_2, var8_11, var9_13);
                        try {
                            while (true) {
                                try {
                                    this.monitor.wait();
                                }
                                catch (InterruptedException var12_17) {
                                    Thread.currentThread().interrupt();
                                    break block44;
                                }
                                if (this.evalRequest != null) {
                                    this.evalResult = null;
                                    try {
                                        this.evalResult = Dim.do_eval(var1_1, this.evalFrame, this.evalRequest);
                                    }
                                    finally {
                                        this.evalRequest = null;
                                        this.evalFrame = null;
                                        this.monitor.notify();
                                    }
                                    continue;
                                }
                                if (this.returnValue != -1) break;
                            }
                            var10_14 = this.returnValue;
                        }
                        finally {
                            this.insideInterruptLoop = false;
                        }
                    }
                }
            }
            this.returnValue = -1;
            this.callback.enterInterrupt(var2_2, var8_11, var9_13);
            while (this.returnValue == -1) {
                try {
                    this.callback.dispatchNextGuiEvent();
                }
                catch (InterruptedException var11_16) {}
            }
            var10_14 = this.returnValue;
            switch (var10_14) {
                case 0: {
                    ContextData.access$1402(var4_4, true);
                    ContextData.access$1502(var4_4, var4_4.frameCount());
                    ** break;
lbl92:
                    // 1 sources

                    break;
                }
                case 1: {
                    ContextData.access$1402(var4_4, true);
                    ContextData.access$1502(var4_4, -1);
                    ** break;
lbl99:
                    // 1 sources

                    break;
                }
                case 2: {
                    if (var4_4.frameCount() <= 1) ** break;
                    ContextData.access$1402(var4_4, true);
                    ContextData.access$1502(var4_4, var4_4.frameCount() - 1);
                    break;
                }
                ** default:
lbl108:
                // 1 sources

                break;
            }
        }
        finally {
            var7_9 = this.eventThreadMonitor;
            synchronized (var7_9) {
                this.interruptedContextData = null;
                this.eventThreadMonitor.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String do_eval(Context context, StackFrame stackFrame, String string) {
        String string2;
        Debugger debugger = context.getDebugger();
        Object object = context.getDebuggerContextData();
        int n = context.getOptimizationLevel();
        context.setDebugger(null, null);
        context.setOptimizationLevel(-1);
        context.setGeneratingDebug(false);
        try {
            Callable callable = (Callable)((Object)context.compileString(string, "", 0, null));
            Object object2 = callable.call(context, stackFrame.scope, stackFrame.thisObj, ScriptRuntime.emptyArgs);
            string2 = object2 == Undefined.instance ? "" : ScriptRuntime.toString(object2);
        }
        catch (Exception exception) {
            string2 = exception.getMessage();
        }
        finally {
            context.setGeneratingDebug(true);
            context.setOptimizationLevel(n);
            context.setDebugger(debugger, object);
        }
        if (string2 == null) {
            string2 = "null";
        }
        return string2;
    }

    public static class SourceInfo {
        private static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
        private String source;
        private String url;
        private boolean[] breakableLines;
        private boolean[] breakpoints;
        private FunctionSource[] functionSources;

        private SourceInfo(String string, DebuggableScript[] debuggableScriptArray, String string2) {
            int n;
            int n2;
            int n3;
            int n4;
            this.source = string;
            this.url = string2;
            int n5 = debuggableScriptArray.length;
            int[][] nArrayArray = new int[n5][];
            for (n4 = 0; n4 != n5; ++n4) {
                nArrayArray[n4] = debuggableScriptArray[n4].getLineNumbers();
            }
            n4 = 0;
            int n6 = -1;
            int[] nArray = new int[n5];
            for (n3 = 0; n3 != n5; ++n3) {
                int[] nArray2 = nArrayArray[n3];
                if (nArray2 == null || nArray2.length == 0) {
                    nArray[n3] = -1;
                    continue;
                }
                int n7 = n2 = nArray2[0];
                for (n = 1; n != nArray2.length; ++n) {
                    int n8 = nArray2[n];
                    if (n8 < n7) {
                        n7 = n8;
                        continue;
                    }
                    if (n8 <= n2) continue;
                    n2 = n8;
                }
                nArray[n3] = n7;
                if (n4 > n6) {
                    n4 = n7;
                    n6 = n2;
                    continue;
                }
                if (n7 < n4) {
                    n4 = n7;
                }
                if (n2 <= n6) continue;
                n6 = n2;
            }
            if (n4 > n6) {
                this.breakableLines = EMPTY_BOOLEAN_ARRAY;
                this.breakpoints = EMPTY_BOOLEAN_ARRAY;
            } else {
                if (n4 < 0) {
                    throw new IllegalStateException(String.valueOf(n4));
                }
                n3 = n6 + 1;
                this.breakableLines = new boolean[n3];
                this.breakpoints = new boolean[n3];
                for (int i = 0; i != n5; ++i) {
                    int[] nArray3 = nArrayArray[i];
                    if (nArray3 == null || nArray3.length == 0) continue;
                    for (n2 = 0; n2 != nArray3.length; ++n2) {
                        n = nArray3[n2];
                        this.breakableLines[n] = true;
                    }
                }
            }
            this.functionSources = new FunctionSource[n5];
            for (n3 = 0; n3 != n5; ++n3) {
                String string3 = debuggableScriptArray[n3].getFunctionName();
                if (string3 == null) {
                    string3 = "";
                }
                this.functionSources[n3] = new FunctionSource(this, nArray[n3], string3);
            }
        }

        public String source() {
            return this.source;
        }

        public String url() {
            return this.url;
        }

        public int functionSourcesTop() {
            return this.functionSources.length;
        }

        public FunctionSource functionSource(int n) {
            return this.functionSources[n];
        }

        private void copyBreakpointsFrom(SourceInfo sourceInfo) {
            int n = sourceInfo.breakpoints.length;
            if (n > this.breakpoints.length) {
                n = this.breakpoints.length;
            }
            for (int i = 0; i != n; ++i) {
                if (!sourceInfo.breakpoints[i]) continue;
                this.breakpoints[i] = true;
            }
        }

        public boolean breakableLine(int n) {
            return n < this.breakableLines.length && this.breakableLines[n];
        }

        public boolean breakpoint(int n) {
            if (!this.breakableLine(n)) {
                throw new IllegalArgumentException(String.valueOf(n));
            }
            return n < this.breakpoints.length && this.breakpoints[n];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean breakpoint(int n, boolean bl) {
            if (!this.breakableLine(n)) {
                throw new IllegalArgumentException(String.valueOf(n));
            }
            boolean[] blArray = this.breakpoints;
            synchronized (this.breakpoints) {
                boolean bl2;
                if (this.breakpoints[n] != bl) {
                    this.breakpoints[n] = bl;
                    bl2 = true;
                } else {
                    bl2 = false;
                }
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return bl2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAllBreakpoints() {
            boolean[] blArray = this.breakpoints;
            synchronized (this.breakpoints) {
                for (int i = 0; i != this.breakpoints.length; ++i) {
                    this.breakpoints[i] = false;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }

    public static class FunctionSource {
        private SourceInfo sourceInfo;
        private int firstLine;
        private String name;

        private FunctionSource(SourceInfo sourceInfo, int n, String string) {
            if (string == null) {
                throw new IllegalArgumentException();
            }
            this.sourceInfo = sourceInfo;
            this.firstLine = n;
            this.name = string;
        }

        public SourceInfo sourceInfo() {
            return this.sourceInfo;
        }

        public int firstLine() {
            return this.firstLine;
        }

        public String name() {
            return this.name;
        }
    }

    public static class StackFrame
    implements DebugFrame {
        private Dim dim;
        private ContextData contextData;
        private Scriptable scope;
        private Scriptable thisObj;
        private FunctionSource fsource;
        private boolean[] breakpoints;
        private int lineNumber;

        private StackFrame(Context context, Dim dim, FunctionSource functionSource) {
            this.dim = dim;
            this.contextData = ContextData.get(context);
            this.fsource = functionSource;
            this.breakpoints = functionSource.sourceInfo().breakpoints;
            this.lineNumber = functionSource.firstLine();
        }

        public void onEnter(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
            this.contextData.pushFrame(this);
            this.scope = scriptable;
            this.thisObj = scriptable2;
            if (this.dim.breakOnEnter) {
                this.dim.handleBreakpointHit(this, context);
            }
        }

        public void onLineChange(Context context, int n) {
            this.lineNumber = n;
            if (!this.breakpoints[n] && !this.dim.breakFlag) {
                boolean bl = this.contextData.breakNextLine;
                if (bl && this.contextData.stopAtFrameDepth >= 0) {
                    boolean bl2 = bl = this.contextData.frameCount() <= this.contextData.stopAtFrameDepth;
                }
                if (!bl) {
                    return;
                }
                this.contextData.stopAtFrameDepth = -1;
                this.contextData.breakNextLine = false;
            }
            this.dim.handleBreakpointHit(this, context);
        }

        public void onExceptionThrown(Context context, Throwable throwable) {
            this.dim.handleExceptionThrown(context, throwable, this);
        }

        public void onExit(Context context, boolean bl, Object object) {
            if (this.dim.breakOnReturn && !bl) {
                this.dim.handleBreakpointHit(this, context);
            }
            this.contextData.popFrame();
        }

        public void onDebuggerStatement(Context context) {
            this.dim.handleBreakpointHit(this, context);
        }

        public SourceInfo sourceInfo() {
            return this.fsource.sourceInfo();
        }

        public ContextData contextData() {
            return this.contextData;
        }

        public Object scope() {
            return this.scope;
        }

        public Object thisObj() {
            return this.thisObj;
        }

        public String getUrl() {
            return this.fsource.sourceInfo().url();
        }

        public int getLineNumber() {
            return this.lineNumber;
        }
    }

    public static class ContextData {
        private ObjArray frameStack = new ObjArray();
        private boolean breakNextLine;
        private int stopAtFrameDepth = -1;
        private boolean eventThreadFlag;
        private Throwable lastProcessedException;

        public static ContextData get(Context context) {
            return (ContextData)context.getDebuggerContextData();
        }

        public int frameCount() {
            return this.frameStack.size();
        }

        public StackFrame getFrame(int n) {
            int n2 = this.frameStack.size() - n - 1;
            return (StackFrame)this.frameStack.get(n2);
        }

        private void pushFrame(StackFrame stackFrame) {
            this.frameStack.push(stackFrame);
        }

        private void popFrame() {
            this.frameStack.pop();
        }

        static /* synthetic */ boolean access$402(ContextData contextData, boolean bl) {
            contextData.eventThreadFlag = bl;
            return contextData.eventThreadFlag;
        }
    }

    private static class DimIProxy
    implements ContextAction,
    ContextFactory.Listener,
    Debugger {
        private Dim dim;
        private int type;
        private String url;
        private String text;
        private Object object;
        private Object id;
        private boolean booleanResult;
        private String stringResult;
        private Object objectResult;
        private Object[] objectArrayResult;

        private DimIProxy(Dim dim, int n) {
            this.dim = dim;
            this.type = n;
        }

        public Object run(Context context) {
            switch (this.type) {
                case 2: {
                    context.compileString(this.text, this.url, 1, null);
                    break;
                }
                case 3: {
                    Scriptable scriptable = null;
                    if (this.dim.scopeProvider != null) {
                        scriptable = this.dim.scopeProvider.getScope();
                    }
                    if (scriptable == null) {
                        scriptable = new ImporterTopLevel(context);
                    }
                    context.evaluateString(scriptable, this.text, this.url, 1, null);
                    break;
                }
                case 4: {
                    this.booleanResult = context.stringIsCompilableUnit(this.text);
                    break;
                }
                case 5: {
                    if (this.object == Undefined.instance) {
                        this.stringResult = "undefined";
                        break;
                    }
                    if (this.object == null) {
                        this.stringResult = "null";
                        break;
                    }
                    if (this.object instanceof NativeCall) {
                        this.stringResult = "[object Call]";
                        break;
                    }
                    this.stringResult = Context.toString(this.object);
                    break;
                }
                case 6: {
                    this.objectResult = this.dim.getObjectPropertyImpl(context, this.object, this.id);
                    break;
                }
                case 7: {
                    this.objectArrayResult = this.dim.getObjectIdsImpl(context, this.object);
                    break;
                }
                default: {
                    throw Kit.codeBug();
                }
            }
            return null;
        }

        private void withContext() {
            this.dim.contextFactory.call(this);
        }

        public void contextCreated(Context context) {
            if (this.type != 1) {
                Kit.codeBug();
            }
            ContextData contextData = new ContextData();
            DimIProxy dimIProxy = new DimIProxy(this.dim, 0);
            context.setDebugger(dimIProxy, contextData);
            context.setGeneratingDebug(true);
            context.setOptimizationLevel(-1);
        }

        public void contextReleased(Context context) {
            if (this.type != 1) {
                Kit.codeBug();
            }
        }

        public DebugFrame getFrame(Context context, DebuggableScript debuggableScript) {
            FunctionSource functionSource;
            if (this.type != 0) {
                Kit.codeBug();
            }
            if ((functionSource = this.dim.getFunctionSource(debuggableScript)) == null) {
                return null;
            }
            return new StackFrame(context, this.dim, functionSource);
        }

        public void handleCompilationDone(Context context, DebuggableScript debuggableScript, String string) {
            if (this.type != 0) {
                Kit.codeBug();
            }
            if (!debuggableScript.isTopLevel()) {
                return;
            }
            this.dim.registerTopScript(debuggableScript, string);
        }
    }
}

