/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Computes the smoothing of an image by convolution with the Gaussian
kernels implemented as IIR filters.


This filter is implemented using the recursive gaussian filters. For
multi-component images, the filter works on each component
independently.

For this filter to be able to run in-place the input and output image
types need to be the same and/or the same type as the RealImageType.
See:
 itk::simple::SmoothingRecursiveGaussian for the procedural interface

 itk::SmoothingRecursiveGaussianImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkSmoothingRecursiveGaussianImageFilter.h
*/
public class SmoothingRecursiveGaussianImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected SmoothingRecursiveGaussianImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.SmoothingRecursiveGaussianImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(SmoothingRecursiveGaussianImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(SmoothingRecursiveGaussianImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::SmoothingRecursiveGaussianImageFilter::~SmoothingRecursiveGaussianImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_SmoothingRecursiveGaussianImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::SmoothingRecursiveGaussianImageFilter::SmoothingRecursiveGaussianImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  SmoothingRecursiveGaussianImageFilter() {
    this(SimpleITKJNI.new_SmoothingRecursiveGaussianImageFilter(), true);
  }

  /**
Self&amp; itk::simple::SmoothingRecursiveGaussianImageFilter::SetSigma(std::vector&lt; double &gt; Sigma)

Set the standard deviation of the Gaussian used for smoothing. Sigma
is measured in the units of image spacing. You may use the method
SetSigma to set the same value across each axis or use the method
SetSigmaArray if you need different values along each axis.

*/
public  void setSigma(VectorDouble Sigma) {
    SimpleITKJNI.SmoothingRecursiveGaussianImageFilter_setSigma__SWIG_0(swigCPtr, this, VectorDouble.getCPtr(Sigma), Sigma);
  }

  /**
Self&amp; itk::simple::SmoothingRecursiveGaussianImageFilter::SetSigma(std::vector&lt; double &gt; Sigma)

Set the standard deviation of the Gaussian used for smoothing. Sigma
is measured in the units of image spacing. You may use the method
SetSigma to set the same value across each axis or use the method
SetSigmaArray if you need different values along each axis.

*/
public  void setSigma(double value) {
    SimpleITKJNI.SmoothingRecursiveGaussianImageFilter_setSigma__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;double&gt; itk::simple::SmoothingRecursiveGaussianImageFilter::GetSigma() const

Get the Sigma scalar. If the Sigma is anisotropic, we will just return
the Sigma along the first dimension.

*/
public  VectorDouble getSigma() {
    return new VectorDouble(SimpleITKJNI.SmoothingRecursiveGaussianImageFilter_getSigma(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::SmoothingRecursiveGaussianImageFilter::SetNormalizeAcrossScale(bool NormalizeAcrossScale)

     Set/Get the flag for normalizing the Gaussian over scale-space.
This method does not effect the output of this filter.


See:
 RecursiveGaussianImageFilter::SetNormalizeAcrossScale


*/
public  void setNormalizeAcrossScale(boolean NormalizeAcrossScale) {
    SimpleITKJNI.SmoothingRecursiveGaussianImageFilter_setNormalizeAcrossScale(swigCPtr, this, NormalizeAcrossScale);
  }

  /**
Self&amp; itk::simple::SmoothingRecursiveGaussianImageFilter::NormalizeAcrossScaleOn()

Set the value of NormalizeAcrossScale to true or false respectfully.

*/
public  void normalizeAcrossScaleOn() {
    SimpleITKJNI.SmoothingRecursiveGaussianImageFilter_normalizeAcrossScaleOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::SmoothingRecursiveGaussianImageFilter::NormalizeAcrossScaleOff()
*/
public  void normalizeAcrossScaleOff() {
    SimpleITKJNI.SmoothingRecursiveGaussianImageFilter_normalizeAcrossScaleOff(swigCPtr, this);
  }

  /**
bool itk::simple::SmoothingRecursiveGaussianImageFilter::GetNormalizeAcrossScale() const

     Set/Get the flag for normalizing the Gaussian over scale-space.
This method does not effect the output of this filter.


See:
 RecursiveGaussianImageFilter::SetNormalizeAcrossScale


*/
public  boolean getNormalizeAcrossScale() {
    return SimpleITKJNI.SmoothingRecursiveGaussianImageFilter_getNormalizeAcrossScale(swigCPtr, this);
  }

  /**
std::string itk::simple::SmoothingRecursiveGaussianImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.SmoothingRecursiveGaussianImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::SmoothingRecursiveGaussianImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.SmoothingRecursiveGaussianImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::SmoothingRecursiveGaussianImageFilter::Execute(Image &amp;&amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.SmoothingRecursiveGaussianImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
