/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Computes the normalized correlation of an image and a template.


This filter calculates the normalized correlation between an image and
the template. Normalized correlation is frequently use in feature
detection because it is invariant to local changes in contrast.

The filter can be given a mask. When presented with an input image and
a mask, the normalized correlation is only calculated at those pixels
under the mask.


See:
 Image

 Neighborhood

 NeighborhoodOperator

 NeighborhoodIterator

 itk::simple::NormalizedCorrelation for the procedural interface

 itk::NormalizedCorrelationImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkNormalizedCorrelationImageFilter.h
*/
public class NormalizedCorrelationImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected NormalizedCorrelationImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.NormalizedCorrelationImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(NormalizedCorrelationImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(NormalizedCorrelationImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::NormalizedCorrelationImageFilter::~NormalizedCorrelationImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_NormalizedCorrelationImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::NormalizedCorrelationImageFilter::NormalizedCorrelationImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  NormalizedCorrelationImageFilter() {
    this(SimpleITKJNI.new_NormalizedCorrelationImageFilter(), true);
  }

  /**
std::string itk::simple::NormalizedCorrelationImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.NormalizedCorrelationImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::NormalizedCorrelationImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.NormalizedCorrelationImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::NormalizedCorrelationImageFilter::Execute(const Image &amp;image, const Image &amp;maskImage, const Image
&amp;templateImage)

Execute the filter on the input image

*/
public  Image execute(Image image, Image maskImage, Image templateImage) {
    return new Image(SimpleITKJNI.NormalizedCorrelationImageFilter_execute(swigCPtr, this, Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, Image.getCPtr(templateImage), templateImage), true);
  }

}
