/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.EnumSet;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRModuleBody;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.OneOperandResultBaseInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class DefineMetaClassInstr
extends OneOperandResultBaseInstr
implements FixedArityInstr {
    private final IRModuleBody metaClassBody;

    public DefineMetaClassInstr(Variable result2, Operand object, IRModuleBody metaClassBody) {
        super(Operation.DEF_META_CLASS, result2, object);
        assert (result2 != null) : "DefineMetaClassInstr result is null";
        this.metaClassBody = metaClassBody;
    }

    public IRModuleBody getMetaClassBody() {
        return this.metaClassBody;
    }

    public Operand getObject() {
        return this.getOperand1();
    }

    @Override
    public boolean computeScopeFlags(IRScope scope, EnumSet<IRFlags> flags2) {
        scope.setCanReceiveNonlocalReturns();
        return true;
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"name: " + this.metaClassBody.getId()};
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new DefineMetaClassInstr(ii.getRenamedVariable(this.result), this.getObject().cloneForInlining(ii), this.metaClassBody);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getMetaClassBody());
    }

    public static DefineMetaClassInstr decode(IRReaderDecoder d) {
        return new DefineMetaClassInstr(d.decodeVariable(), d.decodeOperand(), (IRModuleBody)d.decodeScope());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        IRubyObject obj = (IRubyObject)this.getObject().retrieve(context, self2, currScope, currDynScope, temp);
        return IRRuntimeHelpers.newInterpretedMetaClass(context, this.metaClassBody, obj);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.DefineMetaClassInstr(this);
    }
}

