/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import org.jruby.util.io.SelectorFactory;

public class BlockingIO {
    private static final Map<SelectorProvider, IOSelector> selectors = new ConcurrentHashMap<SelectorProvider, IOSelector>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IOSelector getSelector(SelectorProvider provider) throws IOException {
        IOSelector sel = selectors.get(provider);
        if (sel != null) {
            return sel;
        }
        SelectorProvider selectorProvider = provider;
        synchronized (selectorProvider) {
            sel = selectors.get(provider);
            if (sel == null) {
                sel = new IOSelector(provider);
                selectors.put(provider, sel);
                Thread t = new Thread(sel);
                t.setDaemon(true);
                t.start();
            }
        }
        return sel;
    }

    private static IOSelector getSelector(Channel channel) throws IOException {
        if (!(channel instanceof SelectableChannel)) {
            throw new IllegalArgumentException("channel must be a SelectableChannel");
        }
        return BlockingIO.getSelector(((SelectableChannel)channel).provider());
    }

    public static final Condition newCondition(Channel channel, int ops, Object monitor2) throws IOException {
        return BlockingIO.getSelector(channel).add(channel, ops, monitor2);
    }

    public static final Condition newCondition(Channel channel, int ops) throws IOException {
        return BlockingIO.newCondition(channel, ops, new Object());
    }

    public static void waitForIO(Channel channel, int op) throws InterruptedException, IOException {
        BlockingIO.getSelector(channel).await(channel, op);
    }

    public static void awaitReadable(ReadableByteChannel channel) throws InterruptedException, IOException {
        BlockingIO.waitForIO(channel, 1);
    }

    public static void awaitWritable(WritableByteChannel channel) throws InterruptedException, IOException {
        BlockingIO.waitForIO(channel, 4);
    }

    public static int read(ReadableByteChannel channel, ByteBuffer buf, boolean blocking2) throws IOException {
        int n;
        while ((n = channel.read(buf)) == 0 && blocking2 && channel instanceof SelectableChannel && buf.hasRemaining()) {
            try {
                BlockingIO.awaitReadable(channel);
            }
            catch (InterruptedException ex) {
                throw new InterruptedIOException(ex.getMessage());
            }
        }
        return n;
    }

    public static int write(WritableByteChannel channel, ByteBuffer buf, boolean blocking2) throws IOException {
        int n;
        while ((n = channel.write(buf)) == 0 && blocking2 && channel instanceof SelectableChannel && buf.hasRemaining()) {
            try {
                BlockingIO.awaitWritable(channel);
            }
            catch (InterruptedException ex) {
                throw new InterruptedIOException(ex.getMessage());
            }
        }
        return n;
    }

    public static int blockingRead(ReadableByteChannel channel, ByteBuffer buf) throws IOException {
        return BlockingIO.read(channel, buf, true);
    }

    public static int blockingWrite(WritableByteChannel channel, ByteBuffer buf) throws IOException {
        return BlockingIO.write(channel, buf, true);
    }

    static final class IOSelector
    implements Runnable {
        private final Selector selector;
        private final ConcurrentLinkedQueue<IOChannel> registrationQueue;

        public IOSelector(SelectorProvider provider) throws IOException {
            this.selector = SelectorFactory.openWithRetryFrom(null, provider);
            this.registrationQueue = new ConcurrentLinkedQueue();
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        IOChannel ch;
                        HashSet<SelectionKey> selected = new HashSet<SelectionKey>(this.selector.selectedKeys());
                        for (SelectionKey k : selected) {
                            List waitq = (List)k.attachment();
                            for (IOChannel ch2 : waitq) {
                                ch2.wakeup(true);
                            }
                            waitq.clear();
                        }
                        HashSet<SelectableChannel> added = new HashSet<SelectableChannel>();
                        while ((ch = this.registrationQueue.poll()) != null) {
                            SelectionKey k = ch.channel.keyFor(this.selector);
                            List<IOChannel> waitq = k == null ? new LinkedList() : (List)k.attachment();
                            ch.channel.register(this.selector, ch.ops, waitq);
                            waitq.add(ch);
                            added.add(ch.channel);
                        }
                        for (SelectionKey k : selected) {
                            if (added.contains(k.channel())) continue;
                            k.cancel();
                        }
                        this.selector.select();
                    }
                }
                catch (IOException iOException) {
                    continue;
                }
                break;
            }
        }

        Condition add(Channel channel, int ops, Object monitor2) {
            IOChannel io2 = new IOChannel((SelectableChannel)channel, ops, monitor2);
            this.registrationQueue.add(io2);
            this.selector.wakeup();
            return new Condition(io2);
        }

        public void await(Channel channel, int op) throws InterruptedException {
            this.add(channel, op, new Object()).await();
        }
    }

    public static final class Condition {
        private final IOChannel channel;

        Condition(IOChannel channel) {
            this.channel = channel;
        }

        public void cancel() {
            this.channel.wakeup(false);
        }

        public void interrupt() {
            this.channel.interrupt();
        }

        public boolean await() throws InterruptedException {
            return this.channel.await();
        }

        public boolean await(long timeout2, TimeUnit unit) throws InterruptedException {
            return this.channel.await(timeout2, unit);
        }
    }

    static final class IOChannel {
        final SelectableChannel channel;
        final int ops;
        private final Object monitor;
        private boolean woken = false;
        private boolean ready = false;
        private boolean interrupted = false;

        IOChannel(SelectableChannel channel, int ops, Object monitor2) {
            this.channel = channel;
            this.ops = ops;
            this.monitor = monitor2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void wakeup(boolean ready) {
            Object object = this.monitor;
            synchronized (object) {
                this.woken = true;
                this.ready = ready;
                this.monitor.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void interrupt() {
            Object object = this.monitor;
            synchronized (object) {
                this.woken = true;
                this.interrupted = true;
                this.monitor.notifyAll();
            }
        }

        public final boolean await() throws InterruptedException {
            return this.await(0L, TimeUnit.MILLISECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean await(long timeout2, TimeUnit unit) throws InterruptedException {
            Object object = this.monitor;
            synchronized (object) {
                if (!this.woken) {
                    this.monitor.wait(TimeUnit.MILLISECONDS.convert(timeout2, unit));
                }
                if (this.interrupted) {
                    throw new InterruptedException("Interrupted");
                }
                return this.ready;
            }
        }
    }
}

