/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.basic;

import java.util.BitSet;
import org.hibernate.Internal;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.basic.BasicResultAssembler;
import org.hibernate.sql.results.graph.basic.BasicResultGraphNode;
import org.hibernate.sql.results.graph.basic.CoercingResultAssembler;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.JavaType;

public class BasicResult<T>
implements DomainResult<T>,
BasicResultGraphNode<T> {
    private final String resultVariable;
    private final JavaType<T> javaType;
    private final NavigablePath navigablePath;
    private final BasicResultAssembler<T> assembler;

    public BasicResult(int jdbcValuesArrayPosition, String resultVariable, JdbcMapping jdbcMapping) {
        this(jdbcValuesArrayPosition, resultVariable, jdbcMapping, null, false, false);
    }

    public BasicResult(int jdbcValuesArrayPosition, String resultVariable, JdbcMapping jdbcMapping, NavigablePath navigablePath, boolean coerceResultType, boolean unwrapRowProcessingState) {
        this(jdbcValuesArrayPosition, resultVariable, jdbcMapping.getJavaTypeDescriptor(), jdbcMapping.getValueConverter(), navigablePath, coerceResultType, unwrapRowProcessingState);
    }

    public BasicResult(int valuesArrayPosition, String resultVariable, JavaType<T> javaType, BasicValueConverter<T, ?> valueConverter, NavigablePath navigablePath, boolean coerceResultType, boolean unwrapRowProcessingState) {
        this.resultVariable = resultVariable;
        this.javaType = javaType;
        this.navigablePath = navigablePath;
        this.assembler = coerceResultType ? new CoercingResultAssembler<T>(valuesArrayPosition, javaType, valueConverter, unwrapRowProcessingState) : new BasicResultAssembler<T>(valuesArrayPosition, javaType, valueConverter, unwrapRowProcessingState);
    }

    @Override
    public String getResultVariable() {
        return this.resultVariable;
    }

    public JavaType<T> getResultJavaType() {
        return this.javaType;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Internal
    public DomainResultAssembler<T> getAssembler() {
        return this.assembler;
    }

    @Override
    public DomainResultAssembler<T> createResultAssembler(InitializerParent<?> parent, AssemblerCreationState creationState) {
        return this.assembler;
    }

    @Override
    public void collectValueIndexesToCache(BitSet valueIndexes) {
        valueIndexes.set(this.assembler.valuesArrayPosition);
    }
}

