/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import oracle.jdbc.driver.resource.ResourceType;
import oracle.jdbc.spi.JsonProvider;
import oracle.jdbc.spi.OracleResourceProvider;
import oracle.jdbc.spi.OsonConverter;
import oracle.sql.json.OracleJsonGenerator;
import oracle.sql.json.OracleJsonParser;

public class DefaultJsonProvider
implements JsonProvider {
    private static final String JACKSON_PROVIDER_NAME = "jackson-json-provider";
    private OsonConverter osonConverter = NO_OP_OSON_CONVERTER;
    public static final OsonConverter NO_OP_OSON_CONVERTER = new OsonConverter(){

        @Override
        public void serialize(OracleJsonGenerator oGen, Object object) throws IllegalStateException {
        }

        @Override
        public Object deserialize(OracleJsonParser oParser, Class<?> type) throws IllegalStateException {
            return null;
        }
    };

    @Override
    public String getName() {
        return "ojdbc-default-json-provider";
    }

    @Override
    public OsonConverter getOsonConverter(Map<OracleResourceProvider.Parameter, CharSequence> parameterValues) {
        try {
            ServiceLoader<JsonProvider> serviceLoader = ServiceLoader.load(ResourceType.JSON_PROVIDER.getProviderClass());
            for (JsonProvider provider : serviceLoader) {
                String name = provider.getName();
                if (name == null || !name.equals(JACKSON_PROVIDER_NAME)) continue;
                this.osonConverter = provider.getOsonConverter(parameterValues);
            }
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            // empty catch block
        }
        return this.osonConverter;
    }
}

