/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.util.PriorityQueue;

public final class HitQueue
extends PriorityQueue<ScoreDoc> {
    public HitQueue(int size, boolean prePopulate) {
        super(size, prePopulate ? () -> new ScoreDoc(Integer.MAX_VALUE, Float.NEGATIVE_INFINITY) : () -> null);
    }

    @Override
    protected final boolean lessThan(ScoreDoc hitA, ScoreDoc hitB) {
        int cmp = Float.compare(hitA.score, hitB.score);
        if (cmp == 0) {
            return hitA.doc > hitB.doc;
        }
        return cmp < 0;
    }
}

