/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.extensions.action;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.extensions.proto.ExtensionIdentityProto;
import org.opensearch.extensions.proto.RegisterTransportActionsProto;
import org.opensearch.transport.TransportRequest;

public class RegisterTransportActionsRequest
extends TransportRequest {
    private final RegisterTransportActionsProto.RegisterTransportActions request;

    public RegisterTransportActionsRequest(String uniqueId, Set<String> transportActions) {
        ExtensionIdentityProto.ExtensionIdentity identity = ExtensionIdentityProto.ExtensionIdentity.newBuilder().setUniqueId(uniqueId).build();
        this.request = RegisterTransportActionsProto.RegisterTransportActions.newBuilder().setIdentity(identity).addAllTransportActions(transportActions).build();
    }

    public RegisterTransportActionsRequest(StreamInput in) throws IOException {
        super(in);
        this.request = RegisterTransportActionsProto.RegisterTransportActions.parseFrom(in.readByteArray());
    }

    public String getUniqueId() {
        return this.request.getIdentity().getUniqueId();
    }

    public List<String> getTransportActions() {
        return this.request.getTransportActionsList();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeByteArray(this.request.toByteArray());
    }

    public String toString() {
        return "TransportActionsRequest{Identity=" + String.valueOf(this.request.getIdentity()) + ", actions=" + String.valueOf(this.request.getTransportActionsList()) + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RegisterTransportActionsRequest that = (RegisterTransportActionsRequest)obj;
        return Objects.equals(this.request.getIdentity().getUniqueId(), that.request.getIdentity().getUniqueId()) && Objects.equals(this.request.getTransportActionsList(), that.request.getTransportActionsList());
    }

    public int hashCode() {
        return Objects.hash(this.request.getIdentity(), this.request.getTransportActionsList());
    }
}

