/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.node.resource.tracker;

import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;

public class ResourceTrackerSettings {
    public static final Setting<TimeValue> GLOBAL_CPU_USAGE_AC_POLLING_INTERVAL_SETTING = Setting.positiveTimeSetting("node.resource.tracker.global_cpu_usage.polling_interval", TimeValue.timeValueMillis((long)500L), Setting.Property.NodeScope);
    public static final Setting<TimeValue> GLOBAL_CPU_USAGE_AC_WINDOW_DURATION_SETTING = Setting.positiveTimeSetting("node.resource.tracker.global_cpu_usage.window_duration", TimeValue.timeValueSeconds((long)30L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> GLOBAL_IO_USAGE_AC_POLLING_INTERVAL_SETTING = Setting.positiveTimeSetting("node.resource.tracker.global_io_usage.polling_interval", TimeValue.timeValueMillis((long)5000L), Setting.Property.NodeScope);
    public static final Setting<TimeValue> GLOBAL_IO_USAGE_AC_WINDOW_DURATION_SETTING = Setting.positiveTimeSetting("node.resource.tracker.global_io_usage.window_duration", TimeValue.timeValueSeconds((long)120L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> GLOBAL_JVM_USAGE_AC_POLLING_INTERVAL_SETTING = Setting.positiveTimeSetting("node.resource.tracker.global_jvmmp.polling_interval", TimeValue.timeValueMillis((long)500L), Setting.Property.NodeScope);
    public static final Setting<TimeValue> GLOBAL_JVM_USAGE_AC_WINDOW_DURATION_SETTING = Setting.positiveTimeSetting("node.resource.tracker.global_jvmmp.window_duration", TimeValue.timeValueSeconds((long)30L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile TimeValue cpuWindowDuration;
    private volatile TimeValue cpuPollingInterval;
    private volatile TimeValue memoryWindowDuration;
    private volatile TimeValue memoryPollingInterval;
    private volatile TimeValue ioWindowDuration;
    private volatile TimeValue ioPollingInterval;

    public ResourceTrackerSettings(Settings settings) {
        this.cpuPollingInterval = GLOBAL_CPU_USAGE_AC_POLLING_INTERVAL_SETTING.get(settings);
        this.cpuWindowDuration = GLOBAL_CPU_USAGE_AC_WINDOW_DURATION_SETTING.get(settings);
        this.memoryPollingInterval = GLOBAL_JVM_USAGE_AC_POLLING_INTERVAL_SETTING.get(settings);
        this.memoryWindowDuration = GLOBAL_JVM_USAGE_AC_WINDOW_DURATION_SETTING.get(settings);
        this.ioPollingInterval = GLOBAL_IO_USAGE_AC_POLLING_INTERVAL_SETTING.get(settings);
        this.ioWindowDuration = GLOBAL_IO_USAGE_AC_WINDOW_DURATION_SETTING.get(settings);
    }

    public TimeValue getCpuWindowDuration() {
        return this.cpuWindowDuration;
    }

    public TimeValue getCpuPollingInterval() {
        return this.cpuPollingInterval;
    }

    public TimeValue getMemoryPollingInterval() {
        return this.memoryPollingInterval;
    }

    public TimeValue getMemoryWindowDuration() {
        return this.memoryWindowDuration;
    }

    public TimeValue getIoPollingInterval() {
        return this.ioPollingInterval;
    }

    public TimeValue getIoWindowDuration() {
        return this.ioWindowDuration;
    }

    public void setCpuWindowDuration(TimeValue cpuWindowDuration) {
        this.cpuWindowDuration = cpuWindowDuration;
    }

    public void setMemoryWindowDuration(TimeValue memoryWindowDuration) {
        this.memoryWindowDuration = memoryWindowDuration;
    }

    public void setIoWindowDuration(TimeValue ioWindowDuration) {
        this.ioWindowDuration = ioWindowDuration;
    }

    private static class Defaults {
        private static final long POLLING_INTERVAL_IN_MILLIS = 500L;
        private static final long WINDOW_DURATION_IN_SECONDS = 30L;
        private static final long IO_POLLING_INTERVAL_IN_MILLIS = 5000L;
        private static final long IO_WINDOW_DURATION_IN_SECONDS = 120L;

        private Defaults() {
        }
    }
}

