/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene40.blocktree;

import java.io.IOException;
import org.apache.lucene.backward_codecs.lucene40.blocktree.IntersectTermsEnum;
import org.apache.lucene.backward_codecs.lucene40.blocktree.Lucene40BlockTreeTermsReader;
import org.apache.lucene.backward_codecs.lucene40.blocktree.SegmentTermsEnum;
import org.apache.lucene.backward_codecs.lucene40.blocktree.Stats;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.apache.lucene.util.fst.ByteSequenceOutputs;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.FSTReader;
import org.apache.lucene.util.fst.OffHeapFSTStore;
import org.apache.lucene.util.fst.Outputs;

public final class FieldReader
extends Terms {
    final long numTerms;
    final FieldInfo fieldInfo;
    final long sumTotalTermFreq;
    final long sumDocFreq;
    final int docCount;
    final long rootBlockFP;
    final BytesRef rootCode;
    final BytesRef minTerm;
    final BytesRef maxTerm;
    final Lucene40BlockTreeTermsReader parent;
    final FST<BytesRef> index;

    FieldReader(Lucene40BlockTreeTermsReader parent, FieldInfo fieldInfo, long numTerms, BytesRef rootCode, long sumTotalTermFreq, long sumDocFreq, int docCount, long indexStartFP, IndexInput metaIn, IndexInput indexIn, BytesRef minTerm, BytesRef maxTerm) throws IOException {
        FST.FSTMetadata fstMetadata;
        assert (numTerms > 0L);
        this.fieldInfo = fieldInfo;
        this.parent = parent;
        this.numTerms = numTerms;
        this.sumTotalTermFreq = sumTotalTermFreq;
        this.sumDocFreq = sumDocFreq;
        this.docCount = docCount;
        this.rootCode = rootCode;
        this.minTerm = minTerm;
        this.maxTerm = maxTerm;
        this.rootBlockFP = new ByteArrayDataInput(rootCode.bytes, rootCode.offset, rootCode.length).readVLong() >>> 2;
        if (metaIn == indexIn) {
            IndexInput clone = indexIn.clone();
            clone.seek(indexStartFP);
            fstMetadata = FST.readMetadata((DataInput)clone, (Outputs)ByteSequenceOutputs.getSingleton());
            indexStartFP = clone.getFilePointer();
        } else {
            fstMetadata = FST.readMetadata((DataInput)metaIn, (Outputs)ByteSequenceOutputs.getSingleton());
        }
        this.index = FST.fromFSTReader((FST.FSTMetadata)fstMetadata, (FSTReader)new OffHeapFSTStore(indexIn, indexStartFP, fstMetadata));
    }

    public BytesRef getMin() throws IOException {
        if (this.minTerm == null) {
            return super.getMin();
        }
        return this.minTerm;
    }

    public BytesRef getMax() throws IOException {
        if (this.maxTerm == null) {
            return super.getMax();
        }
        return this.maxTerm;
    }

    public Stats getStats() throws IOException {
        return new SegmentTermsEnum(this).computeBlockStats();
    }

    public boolean hasFreqs() {
        return this.fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) >= 0;
    }

    public boolean hasOffsets() {
        return this.fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
    }

    public boolean hasPositions() {
        return this.fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
    }

    public boolean hasPayloads() {
        return this.fieldInfo.hasPayloads();
    }

    public TermsEnum iterator() throws IOException {
        return new SegmentTermsEnum(this);
    }

    public long size() {
        return this.numTerms;
    }

    public long getSumTotalTermFreq() {
        return this.sumTotalTermFreq;
    }

    public long getSumDocFreq() {
        return this.sumDocFreq;
    }

    public int getDocCount() {
        return this.docCount;
    }

    public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
        if (compiled.type != CompiledAutomaton.AUTOMATON_TYPE.NORMAL) {
            throw new IllegalArgumentException("please use CompiledAutomaton.getTermsEnum instead");
        }
        return new IntersectTermsEnum(this, compiled.getTransitionAccessor(), compiled.getByteRunnable(), compiled.commonSuffixRef, startTerm);
    }

    public String toString() {
        return "BlockTreeTerms(seg=" + this.parent.segment + " terms=" + this.numTerms + ",postings=" + this.sumDocFreq + ",positions=" + this.sumTotalTermFreq + ",docs=" + this.docCount + ")";
    }
}

