/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.search_pipeline;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonEnum;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.search_pipeline.FilterQueryRequestProcessor;
import org.opensearch.client.opensearch.search_pipeline.NeuralQueryEnricherRequestProcessor;
import org.opensearch.client.opensearch.search_pipeline.OversampleRequestProcessor;
import org.opensearch.client.opensearch.search_pipeline.RequestProcessorVariant;
import org.opensearch.client.opensearch.search_pipeline.SearchScriptRequestProcessor;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

@JsonpDeserializable
public class RequestProcessor
implements TaggedUnion<Kind, RequestProcessorVariant>,
PlainJsonSerializable {
    private final Kind _kind;
    private final RequestProcessorVariant _value;
    public static final JsonpDeserializer<RequestProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RequestProcessor::setupRequestProcessorDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final RequestProcessorVariant _get() {
        return this._value;
    }

    public RequestProcessor(RequestProcessorVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._requestProcessorKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private RequestProcessor(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static RequestProcessor of(Function<Builder, ObjectBuilder<RequestProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isFilterQuery() {
        return this._kind == Kind.FilterQuery;
    }

    public FilterQueryRequestProcessor filterQuery() {
        return (FilterQueryRequestProcessor)TaggedUnionUtils.get(this, Kind.FilterQuery);
    }

    public boolean isNeuralQueryEnricher() {
        return this._kind == Kind.NeuralQueryEnricher;
    }

    public NeuralQueryEnricherRequestProcessor neuralQueryEnricher() {
        return (NeuralQueryEnricherRequestProcessor)TaggedUnionUtils.get(this, Kind.NeuralQueryEnricher);
    }

    public boolean isOversample() {
        return this._kind == Kind.Oversample;
    }

    public OversampleRequestProcessor oversample() {
        return (OversampleRequestProcessor)TaggedUnionUtils.get(this, Kind.Oversample);
    }

    public boolean isScript() {
        return this._kind == Kind.Script;
    }

    public SearchScriptRequestProcessor script() {
        return (SearchScriptRequestProcessor)TaggedUnionUtils.get(this, Kind.Script);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)((Object)this._value)).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRequestProcessorDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::filterQuery, FilterQueryRequestProcessor._DESERIALIZER, "filter_query");
        op.add(Builder::neuralQueryEnricher, NeuralQueryEnricherRequestProcessor._DESERIALIZER, "neural_query_enricher");
        op.add(Builder::oversample, OversampleRequestProcessor._DESERIALIZER, "oversample");
        op.add(Builder::script, SearchScriptRequestProcessor._DESERIALIZER, "script");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this._kind);
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestProcessor other = (RequestProcessor)o;
        return Objects.equals(this._kind, other._kind) && Objects.equals(this._value, other._value);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<RequestProcessor> {
        private Kind _kind;
        private RequestProcessorVariant _value;

        public Builder() {
        }

        private Builder(RequestProcessor o) {
            this._kind = o._kind;
            this._value = o._value;
        }

        public ObjectBuilder<RequestProcessor> filterQuery(FilterQueryRequestProcessor v) {
            this._kind = Kind.FilterQuery;
            this._value = v;
            return this;
        }

        public ObjectBuilder<RequestProcessor> filterQuery(Function<FilterQueryRequestProcessor.Builder, ObjectBuilder<FilterQueryRequestProcessor>> fn) {
            return this.filterQuery(fn.apply(new FilterQueryRequestProcessor.Builder()).build());
        }

        public ObjectBuilder<RequestProcessor> neuralQueryEnricher(NeuralQueryEnricherRequestProcessor v) {
            this._kind = Kind.NeuralQueryEnricher;
            this._value = v;
            return this;
        }

        public ObjectBuilder<RequestProcessor> neuralQueryEnricher(Function<NeuralQueryEnricherRequestProcessor.Builder, ObjectBuilder<NeuralQueryEnricherRequestProcessor>> fn) {
            return this.neuralQueryEnricher(fn.apply(new NeuralQueryEnricherRequestProcessor.Builder()).build());
        }

        public ObjectBuilder<RequestProcessor> oversample(OversampleRequestProcessor v) {
            this._kind = Kind.Oversample;
            this._value = v;
            return this;
        }

        public ObjectBuilder<RequestProcessor> oversample(Function<OversampleRequestProcessor.Builder, ObjectBuilder<OversampleRequestProcessor>> fn) {
            return this.oversample(fn.apply(new OversampleRequestProcessor.Builder()).build());
        }

        public ObjectBuilder<RequestProcessor> script(SearchScriptRequestProcessor v) {
            this._kind = Kind.Script;
            this._value = v;
            return this;
        }

        public ObjectBuilder<RequestProcessor> script(Function<SearchScriptRequestProcessor.Builder, ObjectBuilder<SearchScriptRequestProcessor>> fn) {
            return this.script(fn.apply(new SearchScriptRequestProcessor.Builder()).build());
        }

        @Override
        public RequestProcessor build() {
            this._checkSingleUse();
            return new RequestProcessor(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        FilterQuery("filter_query"),
        NeuralQueryEnricher("neural_query_enricher"),
        Oversample("oversample"),
        Script("script");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

