/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ClusterNodeCount
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ClusterNodeCount> {
    @Nullable
    private final Integer clusterManager;
    private final int coordinatingOnly;
    private final int data;
    @Nullable
    private final Integer dataCold;
    @Nullable
    private final Integer dataContent;
    @Nullable
    private final Integer dataFrozen;
    @Nullable
    private final Integer dataHot;
    @Nullable
    private final Integer dataWarm;
    private final int ingest;
    private final int master;
    @Nullable
    private final Integer ml;
    private final int remoteClusterClient;
    @Nullable
    private final Integer search;
    private final int total;
    @Nullable
    private final Integer transform;
    @Nullable
    private final Integer votingOnly;
    @Nullable
    private final Integer warm;
    public static final JsonpDeserializer<ClusterNodeCount> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterNodeCount::setupClusterNodeCountDeserializer);

    private ClusterNodeCount(Builder builder) {
        this.clusterManager = builder.clusterManager;
        this.coordinatingOnly = ApiTypeHelper.requireNonNull(builder.coordinatingOnly, this, "coordinatingOnly");
        this.data = ApiTypeHelper.requireNonNull(builder.data, this, "data");
        this.dataCold = builder.dataCold;
        this.dataContent = builder.dataContent;
        this.dataFrozen = builder.dataFrozen;
        this.dataHot = builder.dataHot;
        this.dataWarm = builder.dataWarm;
        this.ingest = ApiTypeHelper.requireNonNull(builder.ingest, this, "ingest");
        this.master = ApiTypeHelper.requireNonNull(builder.master, this, "master");
        this.ml = builder.ml;
        this.remoteClusterClient = ApiTypeHelper.requireNonNull(builder.remoteClusterClient, this, "remoteClusterClient");
        this.search = builder.search;
        this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");
        this.transform = builder.transform;
        this.votingOnly = builder.votingOnly;
        this.warm = builder.warm;
    }

    public static ClusterNodeCount of(Function<Builder, ObjectBuilder<ClusterNodeCount>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer clusterManager() {
        return this.clusterManager;
    }

    public final int coordinatingOnly() {
        return this.coordinatingOnly;
    }

    public final int data() {
        return this.data;
    }

    @Nullable
    public final Integer dataCold() {
        return this.dataCold;
    }

    @Nullable
    public final Integer dataContent() {
        return this.dataContent;
    }

    @Nullable
    public final Integer dataFrozen() {
        return this.dataFrozen;
    }

    @Nullable
    public final Integer dataHot() {
        return this.dataHot;
    }

    @Nullable
    public final Integer dataWarm() {
        return this.dataWarm;
    }

    public final int ingest() {
        return this.ingest;
    }

    public final int master() {
        return this.master;
    }

    @Nullable
    public final Integer ml() {
        return this.ml;
    }

    public final int remoteClusterClient() {
        return this.remoteClusterClient;
    }

    @Nullable
    public final Integer search() {
        return this.search;
    }

    public final int total() {
        return this.total;
    }

    @Nullable
    public final Integer transform() {
        return this.transform;
    }

    @Nullable
    public final Integer votingOnly() {
        return this.votingOnly;
    }

    @Nullable
    public final Integer warm() {
        return this.warm;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.clusterManager != null) {
            generator.writeKey("cluster_manager");
            generator.write(this.clusterManager.intValue());
        }
        generator.writeKey("coordinating_only");
        generator.write(this.coordinatingOnly);
        generator.writeKey("data");
        generator.write(this.data);
        if (this.dataCold != null) {
            generator.writeKey("data_cold");
            generator.write(this.dataCold.intValue());
        }
        if (this.dataContent != null) {
            generator.writeKey("data_content");
            generator.write(this.dataContent.intValue());
        }
        if (this.dataFrozen != null) {
            generator.writeKey("data_frozen");
            generator.write(this.dataFrozen.intValue());
        }
        if (this.dataHot != null) {
            generator.writeKey("data_hot");
            generator.write(this.dataHot.intValue());
        }
        if (this.dataWarm != null) {
            generator.writeKey("data_warm");
            generator.write(this.dataWarm.intValue());
        }
        generator.writeKey("ingest");
        generator.write(this.ingest);
        generator.writeKey("master");
        generator.write(this.master);
        if (this.ml != null) {
            generator.writeKey("ml");
            generator.write(this.ml.intValue());
        }
        generator.writeKey("remote_cluster_client");
        generator.write(this.remoteClusterClient);
        if (this.search != null) {
            generator.writeKey("search");
            generator.write(this.search.intValue());
        }
        generator.writeKey("total");
        generator.write(this.total);
        if (this.transform != null) {
            generator.writeKey("transform");
            generator.write(this.transform.intValue());
        }
        if (this.votingOnly != null) {
            generator.writeKey("voting_only");
            generator.write(this.votingOnly.intValue());
        }
        if (this.warm != null) {
            generator.writeKey("warm");
            generator.write(this.warm.intValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupClusterNodeCountDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::clusterManager, JsonpDeserializer.integerDeserializer(), "cluster_manager");
        op.add(Builder::coordinatingOnly, JsonpDeserializer.integerDeserializer(), "coordinating_only");
        op.add(Builder::data, JsonpDeserializer.integerDeserializer(), "data");
        op.add(Builder::dataCold, JsonpDeserializer.integerDeserializer(), "data_cold");
        op.add(Builder::dataContent, JsonpDeserializer.integerDeserializer(), "data_content");
        op.add(Builder::dataFrozen, JsonpDeserializer.integerDeserializer(), "data_frozen");
        op.add(Builder::dataHot, JsonpDeserializer.integerDeserializer(), "data_hot");
        op.add(Builder::dataWarm, JsonpDeserializer.integerDeserializer(), "data_warm");
        op.add(Builder::ingest, JsonpDeserializer.integerDeserializer(), "ingest");
        op.add(Builder::master, JsonpDeserializer.integerDeserializer(), "master");
        op.add(Builder::ml, JsonpDeserializer.integerDeserializer(), "ml");
        op.add(Builder::remoteClusterClient, JsonpDeserializer.integerDeserializer(), "remote_cluster_client");
        op.add(Builder::search, JsonpDeserializer.integerDeserializer(), "search");
        op.add(Builder::total, JsonpDeserializer.integerDeserializer(), "total");
        op.add(Builder::transform, JsonpDeserializer.integerDeserializer(), "transform");
        op.add(Builder::votingOnly, JsonpDeserializer.integerDeserializer(), "voting_only");
        op.add(Builder::warm, JsonpDeserializer.integerDeserializer(), "warm");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.clusterManager);
        result = 31 * result + Integer.hashCode(this.coordinatingOnly);
        result = 31 * result + Integer.hashCode(this.data);
        result = 31 * result + Objects.hashCode(this.dataCold);
        result = 31 * result + Objects.hashCode(this.dataContent);
        result = 31 * result + Objects.hashCode(this.dataFrozen);
        result = 31 * result + Objects.hashCode(this.dataHot);
        result = 31 * result + Objects.hashCode(this.dataWarm);
        result = 31 * result + Integer.hashCode(this.ingest);
        result = 31 * result + Integer.hashCode(this.master);
        result = 31 * result + Objects.hashCode(this.ml);
        result = 31 * result + Integer.hashCode(this.remoteClusterClient);
        result = 31 * result + Objects.hashCode(this.search);
        result = 31 * result + Integer.hashCode(this.total);
        result = 31 * result + Objects.hashCode(this.transform);
        result = 31 * result + Objects.hashCode(this.votingOnly);
        result = 31 * result + Objects.hashCode(this.warm);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterNodeCount other = (ClusterNodeCount)o;
        return Objects.equals(this.clusterManager, other.clusterManager) && this.coordinatingOnly == other.coordinatingOnly && this.data == other.data && Objects.equals(this.dataCold, other.dataCold) && Objects.equals(this.dataContent, other.dataContent) && Objects.equals(this.dataFrozen, other.dataFrozen) && Objects.equals(this.dataHot, other.dataHot) && Objects.equals(this.dataWarm, other.dataWarm) && this.ingest == other.ingest && this.master == other.master && Objects.equals(this.ml, other.ml) && this.remoteClusterClient == other.remoteClusterClient && Objects.equals(this.search, other.search) && this.total == other.total && Objects.equals(this.transform, other.transform) && Objects.equals(this.votingOnly, other.votingOnly) && Objects.equals(this.warm, other.warm);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ClusterNodeCount> {
        @Nullable
        private Integer clusterManager;
        private Integer coordinatingOnly;
        private Integer data;
        @Nullable
        private Integer dataCold;
        @Nullable
        private Integer dataContent;
        @Nullable
        private Integer dataFrozen;
        @Nullable
        private Integer dataHot;
        @Nullable
        private Integer dataWarm;
        private Integer ingest;
        private Integer master;
        @Nullable
        private Integer ml;
        private Integer remoteClusterClient;
        @Nullable
        private Integer search;
        private Integer total;
        @Nullable
        private Integer transform;
        @Nullable
        private Integer votingOnly;
        @Nullable
        private Integer warm;

        public Builder() {
        }

        private Builder(ClusterNodeCount o) {
            this.clusterManager = o.clusterManager;
            this.coordinatingOnly = o.coordinatingOnly;
            this.data = o.data;
            this.dataCold = o.dataCold;
            this.dataContent = o.dataContent;
            this.dataFrozen = o.dataFrozen;
            this.dataHot = o.dataHot;
            this.dataWarm = o.dataWarm;
            this.ingest = o.ingest;
            this.master = o.master;
            this.ml = o.ml;
            this.remoteClusterClient = o.remoteClusterClient;
            this.search = o.search;
            this.total = o.total;
            this.transform = o.transform;
            this.votingOnly = o.votingOnly;
            this.warm = o.warm;
        }

        private Builder(Builder o) {
            this.clusterManager = o.clusterManager;
            this.coordinatingOnly = o.coordinatingOnly;
            this.data = o.data;
            this.dataCold = o.dataCold;
            this.dataContent = o.dataContent;
            this.dataFrozen = o.dataFrozen;
            this.dataHot = o.dataHot;
            this.dataWarm = o.dataWarm;
            this.ingest = o.ingest;
            this.master = o.master;
            this.ml = o.ml;
            this.remoteClusterClient = o.remoteClusterClient;
            this.search = o.search;
            this.total = o.total;
            this.transform = o.transform;
            this.votingOnly = o.votingOnly;
            this.warm = o.warm;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder clusterManager(@Nullable Integer value) {
            this.clusterManager = value;
            return this;
        }

        @Nonnull
        public final Builder coordinatingOnly(int value) {
            this.coordinatingOnly = value;
            return this;
        }

        @Nonnull
        public final Builder data(int value) {
            this.data = value;
            return this;
        }

        @Nonnull
        public final Builder dataCold(@Nullable Integer value) {
            this.dataCold = value;
            return this;
        }

        @Nonnull
        public final Builder dataContent(@Nullable Integer value) {
            this.dataContent = value;
            return this;
        }

        @Nonnull
        public final Builder dataFrozen(@Nullable Integer value) {
            this.dataFrozen = value;
            return this;
        }

        @Nonnull
        public final Builder dataHot(@Nullable Integer value) {
            this.dataHot = value;
            return this;
        }

        @Nonnull
        public final Builder dataWarm(@Nullable Integer value) {
            this.dataWarm = value;
            return this;
        }

        @Nonnull
        public final Builder ingest(int value) {
            this.ingest = value;
            return this;
        }

        @Nonnull
        public final Builder master(int value) {
            this.master = value;
            return this;
        }

        @Nonnull
        public final Builder ml(@Nullable Integer value) {
            this.ml = value;
            return this;
        }

        @Nonnull
        public final Builder remoteClusterClient(int value) {
            this.remoteClusterClient = value;
            return this;
        }

        @Nonnull
        public final Builder search(@Nullable Integer value) {
            this.search = value;
            return this;
        }

        @Nonnull
        public final Builder total(int value) {
            this.total = value;
            return this;
        }

        @Nonnull
        public final Builder transform(@Nullable Integer value) {
            this.transform = value;
            return this;
        }

        @Nonnull
        public final Builder votingOnly(@Nullable Integer value) {
            this.votingOnly = value;
            return this;
        }

        @Nonnull
        public final Builder warm(@Nullable Integer value) {
            this.warm = value;
            return this;
        }

        @Override
        @Nonnull
        public ClusterNodeCount build() {
            this._checkSingleUse();
            return new ClusterNodeCount(this);
        }
    }
}

