/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.encoding.impl;

import com.google.common.collect.Lists;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.EncodingException;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.net.URLBuilder;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.servlet.HttpServletSupport;
import net.shibboleth.shared.xml.SerializeSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.messaging.SAMLMessageSecuritySupport;
import org.opensaml.saml.saml2.binding.encoding.impl.BaseSAML2MessageEncoder;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.crypto.XMLSigningUtil;
import org.slf4j.Logger;

public class HTTPRedirectDeflateEncoder
extends BaseSAML2MessageEncoder {
    @Nonnull
    private static final Set<String> DISALLOWED_ENDPOINT_QUERY_PARAMS = CollectionSupport.setOf("SAMLEncoding", "SAMLRequest", "SAMLResponse", "RelayState", "SigAlg", "Signature");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HTTPRedirectDeflateEncoder.class);

    @Override
    @Nonnull
    @NotEmpty
    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect";
    }

    @Override
    protected void doEncode() throws MessageEncodingException {
        MessageContext messageContext = this.getMessageContext();
        Object outboundMessage = messageContext.getMessage();
        if (outboundMessage == null || !(outboundMessage instanceof SAMLObject)) {
            throw new MessageEncodingException("No outbound SAML message contained in message context");
        }
        String endpointURL = this.getEndpointURL(messageContext).toString();
        assert (endpointURL != null);
        this.removeSignature((SAMLObject)outboundMessage);
        String encodedMessage = this.deflateAndBase64Encode((SAMLObject)outboundMessage);
        String redirectURL = this.buildRedirectURL(messageContext, endpointURL, encodedMessage);
        HttpServletResponse response = this.getHttpServletResponse();
        assert (response != null);
        HttpServletSupport.addNoCacheHeaders(response);
        HttpServletSupport.setUTF8Encoding(response);
        try {
            response.sendRedirect(redirectURL);
        }
        catch (IOException e) {
            throw new MessageEncodingException("Problem sending HTTP redirect", e);
        }
    }

    protected void removeSignature(@Nonnull SAMLObject message) {
        SignableSAMLObject signableMessage;
        if (message instanceof SignableSAMLObject && (signableMessage = (SignableSAMLObject)message).isSigned()) {
            this.log.debug("Removing SAML protocol message signature");
            signableMessage.setSignature(null);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    protected String deflateAndBase64Encode(@Nonnull SAMLObject message) throws MessageEncodingException {
        this.log.debug("Deflating and Base64 encoding SAML message");
        try {
            String messageStr = SerializeSupport.nodeToString(this.marshallMessage(message));
            try (ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();){
                String string;
                try (NoWrapAutoEndDeflaterOutputStream deflaterStream = new NoWrapAutoEndDeflaterOutputStream(bytesOut, 8);){
                    deflaterStream.write(messageStr.getBytes("UTF-8"));
                    deflaterStream.finish();
                    string = Base64Support.encode(bytesOut.toByteArray(), false);
                }
                return string;
            }
        }
        catch (IOException | EncodingException e) {
            throw new MessageEncodingException("Unable to DEFLATE and Base64 encode SAML message", e);
        }
    }

    @Nonnull
    protected String buildRedirectURL(@Nonnull MessageContext messageContext, @Nonnull @NotEmpty String endpoint, @Nonnull @NotEmpty String message) throws MessageEncodingException {
        SignatureSigningParameters signingParameters;
        Credential signingCred;
        this.log.debug("Building URL to redirect client to");
        URLBuilder urlBuilder = null;
        try {
            urlBuilder = new URLBuilder(endpoint);
        }
        catch (MalformedURLException e) {
            throw new MessageEncodingException("Endpoint URL " + endpoint + " is not a valid URL", e);
        }
        List<Pair<String, String>> queryParams = urlBuilder.getQueryParams();
        this.removeDisallowedQueryParams(queryParams);
        ArrayList<Pair<String, String>> originalParams = new ArrayList<Pair<String, String>>(queryParams);
        queryParams.clear();
        SAMLObject outboundMessage = (SAMLObject)messageContext.getMessage();
        if (outboundMessage instanceof RequestAbstractType) {
            queryParams.add(new Pair<String, String>("SAMLRequest", message));
        } else if (outboundMessage instanceof StatusResponseType) {
            queryParams.add(new Pair<String, String>("SAMLResponse", message));
        } else {
            throw new MessageEncodingException("SAML message is neither a SAML RequestAbstractType or StatusResponseType");
        }
        String relayState = SAMLBindingSupport.getRelayState(messageContext);
        if (SAMLBindingSupport.checkRelayState(relayState)) {
            queryParams.add(new Pair<String, String>("RelayState", relayState));
        }
        Credential credential = signingCred = (signingParameters = SAMLMessageSecuritySupport.getContextSigningParameters(messageContext)) != null ? signingParameters.getSigningCredential() : null;
        if (signingParameters != null && signingCred != null) {
            String sigAlgURI = this.getSignatureAlgorithmURI(signingParameters);
            Pair<String, String> sigAlg = new Pair<String, String>("SigAlg", sigAlgURI);
            queryParams.add(sigAlg);
            String sigMaterial = urlBuilder.buildQueryString();
            assert (sigMaterial != null);
            queryParams.add(new Pair<String, String>("Signature", this.generateSignature(signingCred, sigAlgURI, sigMaterial)));
            if (!originalParams.isEmpty()) {
                for (Pair param : Lists.reverse(originalParams)) {
                    queryParams.add(0, param);
                }
            }
        } else {
            this.log.debug("No signing credential was supplied, skipping HTTP-Redirect DEFLATE signing");
            queryParams.addAll(originalParams);
        }
        return urlBuilder.buildURL();
    }

    protected void removeDisallowedQueryParams(@Nonnull List<Pair<String, String>> queryParams) {
        Iterator<Pair<String, String>> iter = queryParams.iterator();
        while (iter.hasNext()) {
            String paramName = StringSupport.trimOrNull(iter.next().getFirst());
            if (!DISALLOWED_ENDPOINT_QUERY_PARAMS.contains(paramName)) continue;
            this.log.debug("Removing disallowed query param '{}' from endpoint URL", (Object)paramName);
            iter.remove();
        }
    }

    @Nonnull
    protected String getSignatureAlgorithmURI(@Nonnull SignatureSigningParameters signingParameters) throws MessageEncodingException {
        String alg = signingParameters.getSignatureAlgorithm();
        if (alg != null) {
            return alg;
        }
        throw new MessageEncodingException("The signing algorithm URI could not be determined");
    }

    @Nonnull
    protected String generateSignature(@Nonnull Credential signingCredential, @Nonnull String algorithmURI, @Nonnull String queryString) throws MessageEncodingException {
        this.log.debug("Generating signature with algorithm URI '{}' over query string '{}'", (Object)algorithmURI, (Object)queryString);
        try {
            byte[] rawSignature = XMLSigningUtil.signWithURI(signingCredential, algorithmURI, queryString.getBytes("UTF-8"));
            String b64Signature = Base64Support.encode(rawSignature, false);
            this.log.debug("Generated digital signature value (base64-encoded) {}", (Object)b64Signature);
            return b64Signature;
        }
        catch (SecurityException e) {
            this.log.error("Error during URL signing process: {}", (Object)e.getMessage());
            throw new MessageEncodingException("Unable to sign URL query string", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new MessageEncodingException("Unable to access UTF-8 character encoding?", e);
        }
        catch (EncodingException e) {
            this.log.error("Error during URL signing process: {}", (Object)e.getMessage());
            throw new MessageEncodingException("Unable to base64 encode signature of URL query string", e);
        }
    }

    private class NoWrapAutoEndDeflaterOutputStream
    extends DeflaterOutputStream {
        public NoWrapAutoEndDeflaterOutputStream(OutputStream os, int level) {
            super(os, new Deflater(level, true));
        }

        @Override
        public void close() throws IOException {
            if (this.def != null) {
                this.def.end();
            }
            super.close();
        }
    }
}

