\name{AbsoluteValueDifferenceImageFilter}
\alias{AbsoluteValueDifferenceImageFilter}
\title{AbsoluteValueDifferenceImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Implements pixel-wise the computation of absolute value difference.
AbsoluteValueDifferenceImageFilter}
\details{
This filter is parameterized over the types of the two input images
and the type of the output image.
Numeric conversions (castings) are done by the C++ defaults.
The filter will walk over all the pixels in the two input images, and
for each one of them it will do the following:
Cast the input 1 pixel value to double .
Cast the input 2 pixel value to double .
Compute the difference of the two pixel values.
Compute the absolute value of the difference.
Cast the double value resulting from the absolute value to the pixel
type of the output image.
Store the casted value into the output image.
 The filter expects all images to have the same dimension (e.g. all
2D, or all 3D, or all ND).
See:
AbsoluteValueDifference for the procedural interface
itk::AbsoluteValueDifferenceImageFilter for the Doxygen on the original ITK class.
AbsoluteValueDifferenceImageFilter}
%C++ includes: sitkAbsoluteValueDifferenceImageFilter.h
\section{Methods}{
\describe{
\item{ AbsoluteValueDifferenceImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1, const Image &image2):}{}
\item{Image Execute(const Image &image1, double constant):}{
Execute the filter with an image and a constant
}
\item{Image Execute(double constant, const Image &image2):}{}
\item{Image Execute(Image &&image1, const Image &image2):}{
Execute the filter on the input images
}
\item{Image Execute(Image &&image1, double constant):}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~AbsoluteValueDifferenceImageFilter():}{
Destructor
}
}
}
