//
// Copyright 2025 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#ifndef PXR_USD_IMAGING_USD_SKEL_IMAGING_SKELETON_SCHEMA_H
#define PXR_USD_IMAGING_USD_SKEL_IMAGING_SKELETON_SCHEMA_H

/// \file

#include "pxr/usdImaging/usdSkelImaging/api.h"

#include "pxr/imaging/hd/schema.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

// --(BEGIN CUSTOM CODE: Declares)--
// --(END CUSTOM CODE: Declares)--

#define USD_SKEL_IMAGING_SKELETON_SCHEMA_TOKENS \
    (skeleton) \
    (joints) \
    (jointNames) \
    (bindTransforms) \
    (restTransforms) \

TF_DECLARE_PUBLIC_TOKENS(UsdSkelImagingSkeletonSchemaTokens, USDSKELIMAGING_API,
    USD_SKEL_IMAGING_SKELETON_SCHEMA_TOKENS);

//-----------------------------------------------------------------------------


/// \class UsdSkelImagingSkeletonSchema
///
/// Corresponds to UsdSkelSkeleton.
///
class UsdSkelImagingSkeletonSchema : public HdSchema
{
public:
    /// \name Schema retrieval
    /// @{

    UsdSkelImagingSkeletonSchema(HdContainerDataSourceHandle container)
      : HdSchema(container) {}

    /// Retrieves a container data source with the schema's default name token
    /// "skeleton" from the parent container and constructs a
    /// UsdSkelImagingSkeletonSchema instance.
    /// Because the requested container data source may not exist, the result
    /// should be checked with IsDefined() or a bool comparison before use.
    USDSKELIMAGING_API
    static UsdSkelImagingSkeletonSchema GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer);

    /// @}

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

    /// \name Member accessor
    /// @{

    /// Determines topology of skeleton.
    USDSKELIMAGING_API
    HdTokenArrayDataSourceHandle GetJoints() const;

    /// Here for completeness but ignored for posing the geometry. See
    /// Skeleton.jointNames in usdSkel/schema for uses.
    USDSKELIMAGING_API
    HdTokenArrayDataSourceHandle GetJointNames() const;

    USDSKELIMAGING_API
    HdMatrixArrayDataSourceHandle GetBindTransforms() const;

    /// These are local rest transforms.
    USDSKELIMAGING_API
    HdMatrixArrayDataSourceHandle GetRestTransforms() const; 

    /// @}

    /// \name Schema location
    /// @{

    /// Returns a token where the container representing this schema is found in
    /// a container by default.
    USDSKELIMAGING_API
    static const TfToken &GetSchemaToken();

    /// Returns an HdDataSourceLocator (relative to the prim-level data source)
    /// where the container representing this schema is found by default.
    USDSKELIMAGING_API
    static const HdDataSourceLocator &GetDefaultLocator();

    /// @}

    /// \name Data source locators for members
    ///
    /// The following methods return an HdDataSourceLocator (relative to the
    /// prim-level data source) where the data source for a member can be found.
    ///
    /// This is often useful for checking intersection against the
    /// HdDataSourceLocatorSet sent with HdDataSourceObserver::PrimsDirtied.
    /// @{

    /// Prim-level relative data source locator to locate joints.
    USDSKELIMAGING_API
    static const HdDataSourceLocator &GetJointsLocator();

    /// Prim-level relative data source locator to locate jointNames.
    USDSKELIMAGING_API
    static const HdDataSourceLocator &GetJointNamesLocator();

    /// Prim-level relative data source locator to locate bindTransforms.
    USDSKELIMAGING_API
    static const HdDataSourceLocator &GetBindTransformsLocator();

    /// Prim-level relative data source locator to locate restTransforms.
    USDSKELIMAGING_API
    static const HdDataSourceLocator &GetRestTransformsLocator();
    /// @} 

    /// \name Schema construction
    /// @{

    /// \deprecated Use Builder instead.
    ///
    /// Builds a container data source which includes the provided child data
    /// sources. Parameters with nullptr values are excluded. This is a
    /// low-level interface. For cases in which it's desired to define
    /// the container with a sparse set of child fields, the Builder class
    /// is often more convenient and readable.
    USDSKELIMAGING_API
    static HdContainerDataSourceHandle
    BuildRetained(
        const HdTokenArrayDataSourceHandle &joints,
        const HdTokenArrayDataSourceHandle &jointNames,
        const HdMatrixArrayDataSourceHandle &bindTransforms,
        const HdMatrixArrayDataSourceHandle &restTransforms
    );

    /// \class UsdSkelImagingSkeletonSchema::Builder
    /// 
    /// Utility class for setting sparse sets of child data source fields to be
    /// filled as arguments into BuildRetained. Because all setter methods
    /// return a reference to the instance, this can be used in the "builder
    /// pattern" form.
    class Builder
    {
    public:
        USDSKELIMAGING_API
        Builder &SetJoints(
            const HdTokenArrayDataSourceHandle &joints);
        USDSKELIMAGING_API
        Builder &SetJointNames(
            const HdTokenArrayDataSourceHandle &jointNames);
        USDSKELIMAGING_API
        Builder &SetBindTransforms(
            const HdMatrixArrayDataSourceHandle &bindTransforms);
        USDSKELIMAGING_API
        Builder &SetRestTransforms(
            const HdMatrixArrayDataSourceHandle &restTransforms);

        /// Returns a container data source containing the members set thus far.
        USDSKELIMAGING_API
        HdContainerDataSourceHandle Build();

    private:
        HdTokenArrayDataSourceHandle _joints;
        HdTokenArrayDataSourceHandle _jointNames;
        HdMatrixArrayDataSourceHandle _bindTransforms;
        HdMatrixArrayDataSourceHandle _restTransforms;

    };

    /// @}
};

PXR_NAMESPACE_CLOSE_SCOPE

#endif
