//=============================================================================
//
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=============================================================================

#ifndef FIDES_EXPORT_H
#define FIDES_EXPORT_H

#if defined(_MSC_VER)
# if 0
    /* This is a static component and has no need for exports
       elf based static libraries are able to have hidden/default visibility
       controls on symbols so we should propagate this information in that
       use case
    */
#   define FIDES_EXPORT_DEFINE
#   define FIDES_IMPORT_DEFINE
#   define FIDES_NO_EXPORT_DEFINE
# else
#   define FIDES_EXPORT_DEFINE __declspec(dllexport)
#   define FIDES_IMPORT_DEFINE __declspec(dllimport)
#   define FIDES_NO_EXPORT_DEFINE
# endif
#else
#   define FIDES_EXPORT_DEFINE __attribute__((visibility("default")))
#   define FIDES_IMPORT_DEFINE __attribute__((visibility("default")))
#   define FIDES_NO_EXPORT_DEFINE __attribute__((visibility("hidden")))
#endif

#ifndef FIDES_EXPORT
# if defined(fides_EXPORTS)
    /* We are building this library */
#   define FIDES_EXPORT FIDES_EXPORT_DEFINE
# else
    /* We are using this library */
#   define FIDES_EXPORT FIDES_IMPORT_DEFINE
# endif
#endif

#ifndef FIDES_TEMPLATE_EXPORT
# if defined(fides_EXPORTS) && defined(_MSC_VER)
  /* Warning C4910 on windows state that extern explicit template can't be
     labeled with __declspec(dllexport). So that is why we use a new custom
     define. But when other modules ( e.g. rendering ) include this header
     we need them to see that the extern template is actually being imported.
  */
    /* We are building this library with MSVC */
#   define FIDES_TEMPLATE_EXPORT
# elif defined(fides_EXPORTS)
    /* We are building this library */
#   define FIDES_TEMPLATE_EXPORT FIDES_EXPORT_DEFINE
# else
    /* We are using this library */
#   define FIDES_TEMPLATE_EXPORT FIDES_IMPORT_DEFINE
# endif
#endif

#ifndef FIDES_NO_EXPORT
  #define FIDES_NO_EXPORT FIDES_NO_EXPORT_DEFINE
#endif

#endif

